/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.client;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketReceiveEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.Location;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.Vector3d;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;

public class WrapperPlayClientPlayerFlying
extends PacketWrapper<WrapperPlayClientPlayerFlying> {
    private boolean positionChanged;
    private boolean rotationChanged;
    private Location location;
    private boolean onGround;

    public WrapperPlayClientPlayerFlying(PacketReceiveEvent event) {
        super(event, false);
        this.positionChanged = event.getPacketType() == PacketType.Play.Client.PLAYER_POSITION || event.getPacketType() == PacketType.Play.Client.PLAYER_POSITION_AND_ROTATION;
        this.rotationChanged = event.getPacketType() == PacketType.Play.Client.PLAYER_ROTATION || event.getPacketType() == PacketType.Play.Client.PLAYER_POSITION_AND_ROTATION;
        this.readEvent(event);
    }

    public WrapperPlayClientPlayerFlying(boolean positionChanged, boolean rotationChanged, boolean onGround, Location location) {
        super(positionChanged && rotationChanged ? PacketType.Play.Client.PLAYER_POSITION_AND_ROTATION : (positionChanged ? PacketType.Play.Client.PLAYER_POSITION : (rotationChanged ? PacketType.Play.Client.PLAYER_ROTATION : PacketType.Play.Client.PLAYER_FLYING)));
        this.positionChanged = positionChanged;
        this.rotationChanged = rotationChanged;
        this.onGround = onGround;
        this.location = location;
    }

    public static boolean isFlying(PacketTypeCommon type) {
        return type == PacketType.Play.Client.PLAYER_FLYING || type == PacketType.Play.Client.PLAYER_POSITION || type == PacketType.Play.Client.PLAYER_ROTATION || type == PacketType.Play.Client.PLAYER_POSITION_AND_ROTATION;
    }

    @Override
    public void read() {
        Vector3d position = new Vector3d();
        float yaw = 0.0f;
        float pitch = 0.0f;
        if (this.positionChanged) {
            double x = this.readDouble();
            double y = this.readDouble();
            if (this.serverVersion == ServerVersion.V_1_7_10) {
                double d = this.readDouble();
            }
            double z = this.readDouble();
            position = new Vector3d(x, y, z);
        }
        if (this.rotationChanged) {
            yaw = this.readFloat();
            pitch = this.readFloat();
        }
        this.location = new Location(position, yaw, pitch);
        this.onGround = this.readBoolean();
    }

    @Override
    public void write() {
        if (this.positionChanged) {
            this.writeDouble(this.location.getPosition().getX());
            if (this.serverVersion == ServerVersion.V_1_7_10) {
                this.writeDouble(this.location.getPosition().getY() + 1.62);
            }
            this.writeDouble(this.location.getPosition().getY());
            this.writeDouble(this.location.getPosition().getZ());
        }
        if (this.rotationChanged) {
            this.writeFloat(this.location.getYaw());
            this.writeFloat(this.location.getPitch());
        }
        this.writeBoolean(this.onGround);
    }

    @Override
    public void copy(WrapperPlayClientPlayerFlying wrapper) {
        this.positionChanged = wrapper.positionChanged;
        this.rotationChanged = wrapper.rotationChanged;
        this.location = wrapper.location;
        this.onGround = wrapper.onGround;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public boolean hasPositionChanged() {
        return this.positionChanged;
    }

    public void setPositionChanged(boolean positionChanged) {
        this.positionChanged = positionChanged;
    }

    public boolean hasRotationChanged() {
        return this.rotationChanged;
    }

    public void setRotationChanged(boolean rotationChanged) {
        this.rotationChanged = rotationChanged;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public void setOnGround(boolean onGround) {
        this.onGround = onGround;
    }
}

