/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.client;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketReceiveEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.ItemStack;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.InteractionHand;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.BlockFace;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.Vector3f;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.Vector3i;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.util.Optional;

public class WrapperPlayClientPlayerBlockPlacement
extends PacketWrapper<WrapperPlayClientPlayerBlockPlacement> {
    private InteractionHand interactionHand;
    private Vector3i blockPosition;
    private int faceId;
    private BlockFace face;
    private Vector3f cursorPosition;
    private Optional<ItemStack> itemStack;
    private Optional<Boolean> insideBlock;
    private int sequence;

    public WrapperPlayClientPlayerBlockPlacement(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientPlayerBlockPlacement(InteractionHand interactionHand, Vector3i blockPosition, BlockFace face, Vector3f cursorPosition, ItemStack itemStack, Boolean insideBlock, int sequence) {
        super(PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT);
        this.interactionHand = interactionHand;
        this.blockPosition = blockPosition;
        this.face = face;
        this.faceId = face.getFaceValue();
        this.cursorPosition = cursorPosition;
        this.itemStack = Optional.ofNullable(itemStack);
        this.insideBlock = Optional.ofNullable(insideBlock);
        this.sequence = sequence;
    }

    @Override
    public void read() {
        this.itemStack = Optional.empty();
        this.insideBlock = Optional.empty();
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            this.interactionHand = InteractionHand.getById(this.readVarInt());
            this.blockPosition = this.readBlockPosition();
            this.faceId = this.readVarInt();
            this.face = BlockFace.getBlockFaceByValue(this.faceId);
            this.cursorPosition = new Vector3f(this.readFloat(), this.readFloat(), this.readFloat());
            this.insideBlock = Optional.of(this.readBoolean());
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
                this.sequence = this.readVarInt();
            }
        } else {
            this.blockPosition = this.serverVersion == ServerVersion.V_1_7_10 ? new Vector3i(this.readInt(), this.readUnsignedByte(), this.readInt()) : this.readBlockPosition();
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
                this.faceId = this.readVarInt();
                this.face = BlockFace.getBlockFaceByValue(this.faceId);
                this.interactionHand = InteractionHand.getById(this.readVarInt());
            } else {
                this.faceId = this.readUnsignedByte();
                this.face = BlockFace.getLegacyBlockFaceByValue(this.faceId);
                this.itemStack = Optional.of(this.readItemStack());
                this.interactionHand = InteractionHand.MAIN_HAND;
            }
            this.cursorPosition = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_11) ? new Vector3f(this.readFloat(), this.readFloat(), this.readFloat()) : new Vector3f((float)this.readUnsignedByte() / 16.0f, (float)this.readUnsignedByte() / 16.0f, (float)this.readUnsignedByte() / 16.0f);
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            this.writeVarInt(this.interactionHand.getId());
            this.writeBlockPosition(this.blockPosition);
            this.writeVarInt(this.faceId);
            this.writeFloat(this.cursorPosition.x);
            this.writeFloat(this.cursorPosition.y);
            this.writeFloat(this.cursorPosition.z);
            this.writeBoolean(this.insideBlock.orElse(false));
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
                this.writeVarInt(this.sequence);
            }
        } else {
            if (this.serverVersion == ServerVersion.V_1_7_10) {
                this.writeInt(this.blockPosition.x);
                this.writeByte(this.blockPosition.y);
                this.writeInt(this.blockPosition.z);
            } else {
                this.writeBlockPosition(this.blockPosition);
            }
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
                this.writeVarInt(this.faceId);
                this.writeVarInt(this.interactionHand.getId());
            } else {
                this.writeByte(this.faceId);
                this.writeItemStack(this.itemStack.orElse(ItemStack.EMPTY));
            }
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_11)) {
                this.writeFloat(this.cursorPosition.x);
                this.writeFloat(this.cursorPosition.y);
                this.writeFloat(this.cursorPosition.z);
            } else {
                this.writeByte((int)(this.cursorPosition.x * 16.0f));
                this.writeByte((int)(this.cursorPosition.y * 16.0f));
                this.writeByte((int)(this.cursorPosition.z * 16.0f));
            }
        }
    }

    @Override
    public void copy(WrapperPlayClientPlayerBlockPlacement wrapper) {
        this.interactionHand = wrapper.interactionHand;
        this.blockPosition = wrapper.blockPosition;
        this.face = wrapper.face;
        this.faceId = wrapper.faceId;
        this.cursorPosition = wrapper.cursorPosition;
        this.itemStack = wrapper.itemStack;
        this.insideBlock = wrapper.insideBlock;
        this.sequence = wrapper.sequence;
    }

    public InteractionHand getHand() {
        return this.interactionHand;
    }

    public void setHand(InteractionHand interactionHand) {
        this.interactionHand = interactionHand;
    }

    public Vector3i getBlockPosition() {
        return this.blockPosition;
    }

    public void setBlockPosition(Vector3i blockPosition) {
        this.blockPosition = blockPosition;
    }

    public int getFaceId() {
        return this.faceId;
    }

    public void setFaceId(int faceId) {
        this.faceId = faceId;
        this.face = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9) ? BlockFace.getBlockFaceByValue(faceId) : BlockFace.getLegacyBlockFaceByValue(faceId);
    }

    public BlockFace getFace() {
        return this.face;
    }

    public void setFace(BlockFace face) {
        this.face = face;
        this.faceId = face.getFaceValue();
    }

    public Vector3f getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(Vector3f cursorPosition) {
        this.cursorPosition = cursorPosition;
    }

    public Optional<ItemStack> getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(Optional<ItemStack> itemStack) {
        this.itemStack = itemStack;
    }

    public Optional<Boolean> getInsideBlock() {
        return this.insideBlock;
    }

    public void setInsideBlock(Optional<Boolean> insideBlock) {
        this.insideBlock = insideBlock;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }
}

