/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTCompound;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTNumber;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTString;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.VersionMapper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.ListDiff;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.MapDiff;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.MappingHelper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilderData;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TypesBuilder {
    private final String mapPath;
    private Map<ClientVersion, Map<String, Integer>> entries = new HashMap<ClientVersion, Map<String, Integer>>();
    private VersionMapper versionMapper;

    public TypesBuilder(String mapPath, boolean lazy) {
        this.mapPath = mapPath;
        if (!lazy) {
            this.load();
        }
    }

    public TypesBuilder(String mapPath) {
        this(mapPath, false);
    }

    public void load() {
        NBTCompound compound = MappingHelper.decompress("mappings/" + this.mapPath);
        ClientVersion start = ClientVersion.valueOf(compound.getStringTagValueOrThrow("start"));
        NBTCompound entries = compound.getCompoundTagOrThrow("entries");
        ClientVersion[] versions = new ClientVersion[entries.size()];
        int index = 0;
        for (String name : entries.getTagNames()) {
            try {
                versions[index] = ClientVersion.valueOf(name);
                ++index;
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("Issue found in PacketEvents " + this.mapPath + " mappings. '" + name + "' is not a unique protocol release version! (It might just be a minecraft release version, not necessarily a unique protocol version)");
            }
        }
        this.versionMapper = new VersionMapper(versions);
        if (entries.getTagOrThrow(start.name()).getType().equals(NBTType.LIST)) {
            this.loadAsArray(start, entries, versions);
        } else {
            this.loadAsMap(start, entries, versions);
        }
    }

    private void loadAsArray(ClientVersion start, NBTCompound entries, ClientVersion[] versions) {
        List lastEntries = entries.getStringListTagOrThrow(start.name()).getTags().stream().map(NBTString::getValue).collect(Collectors.toList());
        Consumer<ClientVersion> mapLoader = version -> {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int i = 0; i < lastEntries.size(); ++i) {
                map.put((String)lastEntries.get(i), i);
            }
            this.entries.put((ClientVersion)((Object)version), (Map<String, Integer>)map);
        };
        mapLoader.accept(start);
        for (int i = 1; i < versions.length; ++i) {
            ClientVersion version2 = versions[i];
            ListDiff<String>[] diff = MappingHelper.createListDiff(entries.getCompoundTagOrThrow(version2.name()));
            for (int j = diff.length - 1; j >= 0; --j) {
                diff[j].applyTo(lastEntries);
            }
            mapLoader.accept(version2);
        }
    }

    private void loadAsMap(ClientVersion start, NBTCompound entries, ClientVersion[] versions) {
        Map<String, Integer> lastEntries = entries.getCompoundTagOrThrow(start.name()).getTags().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, Integer>((String)entry.getKey(), ((NBTNumber)entry.getValue()).getAsInt())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Consumer<ClientVersion> mapLoader = version -> {
            HashMap map = new HashMap(lastEntries);
            this.entries.put((ClientVersion)((Object)version), map);
        };
        mapLoader.accept(start);
        for (int i = 1; i < versions.length; ++i) {
            MapDiff<String, Integer>[] diff;
            ClientVersion version2 = versions[i];
            for (MapDiff<String, Integer> d : diff = MappingHelper.createDiff(entries.getCompoundTagOrThrow(version2.name()))) {
                d.applyTo(lastEntries);
            }
            mapLoader.accept(version2);
        }
    }

    public ClientVersion[] getVersions() {
        return this.versionMapper.getVersions();
    }

    public ClientVersion[] getReversedVersions() {
        return this.versionMapper.getReversedVersions();
    }

    public int getDataIndex(ClientVersion rawVersion) {
        return this.versionMapper.getIndex(rawVersion);
    }

    public void unloadFileMappings() {
        this.entries.clear();
        this.entries = null;
    }

    public TypesBuilderData define(String key) {
        ResourceLocation name = new ResourceLocation(key);
        int[] ids = new int[this.getVersions().length];
        int index = 0;
        for (ClientVersion v : this.getVersions()) {
            int id;
            Map<String, Integer> map = this.entries.get((Object)v);
            ids[index] = map.containsKey(key) ? (id = map.get(key).intValue()) : -1;
            ++index;
        }
        return new TypesBuilderData(name, ids);
    }
}

