/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEvents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.mapper.MappedEntity;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBT;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTCompound;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTLimiter;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTList;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTNumber;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTString;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.serializer.DefaultNBTSerializer;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.ListDiff;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.MapDiff;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilder;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilderData;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;

public class MappingHelper {
    public static NBTCompound decompress(String path) {
        NBTCompound nBTCompound;
        NBTLimiter limiter = new NBTLimiter();
        DataInputStream dataInput = new DataInputStream(new GZIPInputStream(new BufferedInputStream(PacketEvents.getAPI().getSettings().getResourceProvider().apply("assets/" + path + ".nbt"))));
        try {
            nBTCompound = (NBTCompound)DefaultNBTSerializer.INSTANCE.deserializeTag(limiter, dataInput);
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataInput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot find resource file " + path + ".nbt", e);
            }
        }
        dataInput.close();
        return nBTCompound;
    }

    public static ListDiff<String>[] createListDiff(NBTCompound compound) {
        NBTList<NBTCompound> additions = compound.getCompoundListTagOrThrow("additions");
        NBTList<NBTCompound> removals = compound.getCompoundListTagOrThrow("removals");
        NBTList<NBTCompound> changes = compound.getCompoundListTagOrThrow("changes");
        ListDiff[] diffs = new ListDiff[additions.size() + removals.size() + changes.size()];
        int index = 0;
        for (NBTCompound entry : removals.getTags()) {
            diffs[index++] = new ListDiff.Removal(entry.getNumberTagOrThrow("pos").getAsInt(), entry.getNumberTagOrThrow("size").getAsInt());
        }
        for (NBTCompound entry : additions.getTags()) {
            diffs[index++] = new ListDiff.Addition(entry.getNumberTagOrThrow("pos").getAsInt(), entry.getStringListTagOrThrow("lines").getTags().stream().map(NBTString::getValue).collect(Collectors.toList()));
        }
        for (NBTCompound entry : changes.getTags()) {
            diffs[index++] = new ListDiff.Changed(entry.getNumberTagOrThrow("pos").getAsInt(), entry.getNumberTagOrThrow("size").getAsInt(), entry.getStringListTagOrThrow("lines").getTags().stream().map(NBTString::getValue).collect(Collectors.toList()));
        }
        Arrays.sort(diffs, Comparator.comparingInt(ListDiff::getIndex));
        return diffs;
    }

    public static MapDiff<String, Integer>[] createDiff(NBTCompound compound) {
        NBTCompound additions = compound.getCompoundTagOrThrow("additions");
        NBTCompound removal = compound.getCompoundTagOrThrow("removals");
        MapDiff[] diffs = new MapDiff[additions.size() + removal.size()];
        int index = 0;
        for (Map.Entry<String, NBT> entry : removal.getTags().entrySet()) {
            diffs[index++] = new MapDiff.Removal(entry.getKey());
        }
        for (Map.Entry<String, NBT> entry : additions.getTags().entrySet()) {
            diffs[index++] = new MapDiff.Addition<String, Integer>(entry.getKey(), ((NBTNumber)entry.getValue()).getAsInt());
        }
        return diffs;
    }

    public static <T extends MappedEntity> void registerMapping(TypesBuilder builder, Map<String, T> typeMap, Map<Byte, Map<Integer, T>> typeIdMap, T type) {
        typeMap.put(type.getName().toString(), type);
        for (ClientVersion version : builder.getVersions()) {
            int index = builder.getDataIndex(version);
            Map idMap = typeIdMap.computeIfAbsent((byte)index, k -> new HashMap());
            idMap.put(type.getId(version), type);
        }
    }

    public static int getId(ClientVersion version, TypesBuilder builder, TypesBuilderData data) {
        return data.getData()[builder.getDataIndex(version)];
    }
}

