/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PEVersion
implements Comparable<PEVersion> {
    private final int major;
    private final int minor;
    private final int patch;
    private final boolean snapshot;

    public PEVersion(int major, int minor, int patch, boolean snapshot) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.snapshot = snapshot;
    }

    public PEVersion(int major, int minor, int patch) {
        this(major, minor, patch, false);
    }

    @Deprecated
    public PEVersion(int ... version) {
        this(version[0], version[1], version[2]);
    }

    @Deprecated
    public PEVersion(@NotNull String version) {
        String versionWithoutSnapshot = version.replace("-SNAPSHOT", "");
        String[] parts = versionWithoutSnapshot.split("\\.");
        if (parts.length < 2 || parts.length > 3) {
            throw new IllegalArgumentException("Version string must be in the format 'major.minor[.patch][-SNAPSHOT]' found '" + version + "' instead.");
        }
        this.major = Integer.parseInt(parts[0]);
        this.minor = Integer.parseInt(parts[1]);
        this.patch = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
        this.snapshot = version.contains("-SNAPSHOT");
    }

    public static PEVersion fromString(@NotNull String version) {
        return new PEVersion(version);
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public boolean snapshot() {
        return this.snapshot;
    }

    @Override
    public int compareTo(@NotNull PEVersion other) {
        int majorCompare = Integer.compare(this.major, other.major);
        if (majorCompare != 0) {
            return majorCompare;
        }
        int minorCompare = Integer.compare(this.minor, other.minor);
        if (minorCompare != 0) {
            return minorCompare;
        }
        int patchCompare = Integer.compare(this.patch, other.patch);
        if (patchCompare != 0) {
            return patchCompare;
        }
        return Boolean.compare(other.snapshot, this.snapshot);
    }

    public boolean equals(@NotNull Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PEVersion)) {
            return false;
        }
        PEVersion other = (PEVersion)obj;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch && this.snapshot == other.snapshot;
    }

    public boolean isNewerThan(@NotNull PEVersion otherVersion) {
        return this.compareTo(otherVersion) > 0;
    }

    public boolean isOlderThan(@NotNull PEVersion otherVersion) {
        return this.compareTo(otherVersion) < 0;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.snapshot);
    }

    public PEVersion clone() {
        return new PEVersion(this.major, this.minor, this.patch, this.snapshot);
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + (this.snapshot ? "-SNAPSHOT" : "");
    }

    @Deprecated
    public int[] asArray() {
        return new int[]{this.major, this.minor, this.patch};
    }
}

