/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.positionsource.builtin;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.positionsource.PositionSource;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.positionsource.PositionSourceTypes;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;

public class EntityPositionSource
extends PositionSource {
    private int entityId;
    private float offsetY;

    public EntityPositionSource(int entityId) {
        this(entityId, 0.0f);
    }

    public EntityPositionSource(int entityId, float offsetY) {
        super(PositionSourceTypes.ENTITY);
        this.entityId = entityId;
        this.offsetY = offsetY;
    }

    public static EntityPositionSource read(PacketWrapper<?> wrapper) {
        int entityId = wrapper.readVarInt();
        float offsetY = 0.0f;
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19)) {
            offsetY = wrapper.readFloat();
        }
        return new EntityPositionSource(entityId, offsetY);
    }

    public static void write(PacketWrapper<?> wrapper, EntityPositionSource source) {
        wrapper.writeVarInt(source.entityId);
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19)) {
            wrapper.writeFloat(source.offsetY);
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(float offsetY) {
        this.offsetY = offsetY;
    }
}

