/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.positionsource;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.positionsource.PositionSource;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.positionsource.PositionSourceType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.positionsource.builtin.BlockPositionSource;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.positionsource.builtin.EntityPositionSource;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.MappingHelper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilder;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilderData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.util.HashMap;
import java.util.Map;

public class PositionSourceTypes {
    private static final Map<String, PositionSourceType<?>> POS_SOURCE_MAP = new HashMap();
    private static final Map<Byte, Map<Integer, PositionSourceType<?>>> POS_SOURCE_ID_MAP = new HashMap();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("world/world_position_source_mappings");
    public static final PositionSourceType<BlockPositionSource> BLOCK = PositionSourceTypes.define("block", BlockPositionSource::read, BlockPositionSource::write);
    public static final PositionSourceType<EntityPositionSource> ENTITY = PositionSourceTypes.define("entity", EntityPositionSource::read, EntityPositionSource::write);

    public static <T extends PositionSource> PositionSourceType<T> define(String key, final PacketWrapper.Reader<T> reader, final PacketWrapper.Writer<T> writer) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        PositionSourceType sourceType = new PositionSourceType<T>(){

            @Override
            public T read(PacketWrapper<?> wrapper) {
                return (PositionSource)reader.apply(wrapper);
            }

            @Override
            public void write(PacketWrapper<?> wrapper, T source) {
                writer.accept(wrapper, source);
            }

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                return MappingHelper.getId(version, TYPES_BUILDER, data);
            }

            public boolean equals(Object obj) {
                if (obj instanceof PositionSourceType) {
                    return this.getName().equals(((PositionSourceType)obj).getName());
                }
                return false;
            }
        };
        MappingHelper.registerMapping(TYPES_BUILDER, POS_SOURCE_MAP, POS_SOURCE_ID_MAP, sourceType);
        return sourceType;
    }

    public static PositionSourceType<?> getByName(String name) {
        return POS_SOURCE_MAP.get(name);
    }

    public static PositionSourceType<?> getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, PositionSourceType<?>> idMap = POS_SOURCE_ID_MAP.get((byte)index);
        return idMap.get(id);
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }
}

