/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.painting;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.painting.PaintingVariant;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.MappingHelper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilder;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilderData;
import java.util.HashMap;
import java.util.Map;

public class PaintingVariants {
    private static final Map<String, PaintingVariant> PAINTING_TYPE_MAP = new HashMap<String, PaintingVariant>();
    private static final Map<Byte, Map<Integer, PaintingVariant>> PAINTING_TYPE_ID_MAP = new HashMap<Byte, Map<Integer, PaintingVariant>>();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("item/item_banner_pattern_mappings");
    public static final PaintingVariant POINTER = PaintingVariants.define("pointer", 4, 4);
    public static final PaintingVariant CREEBET = PaintingVariants.define("creebet", 2, 1);
    public static final PaintingVariant PRAIRIE_RIDE = PaintingVariants.define("prairie_ride", 1, 2);
    public static final PaintingVariant POOL = PaintingVariants.define("pool", 2, 1);
    public static final PaintingVariant EARTH = PaintingVariants.define("earth", 2, 2);
    public static final PaintingVariant SKELETON = PaintingVariants.define("skeleton", 4, 3);
    public static final PaintingVariant MATCH = PaintingVariants.define("match", 2, 2);
    public static final PaintingVariant POND = PaintingVariants.define("pond", 3, 4);
    public static final PaintingVariant HUMBLE = PaintingVariants.define("humble", 2, 2);
    public static final PaintingVariant PIGSCENE = PaintingVariants.define("pigscene", 4, 4);
    public static final PaintingVariant WATER = PaintingVariants.define("water", 2, 2);
    public static final PaintingVariant ALBAN = PaintingVariants.define("alban", 1, 1);
    public static final PaintingVariant FINDING = PaintingVariants.define("finding", 4, 2);
    public static final PaintingVariant AZTEC2 = PaintingVariants.define("aztec2", 1, 1);
    public static final PaintingVariant TIDES = PaintingVariants.define("tides", 3, 3);
    public static final PaintingVariant FIGHTERS = PaintingVariants.define("fighters", 4, 2);
    public static final PaintingVariant FIRE = PaintingVariants.define("fire", 2, 2);
    public static final PaintingVariant CHANGING = PaintingVariants.define("changing", 4, 2);
    public static final PaintingVariant BURNING_SKULL = PaintingVariants.define("burning_skull", 4, 4);
    public static final PaintingVariant COTAN = PaintingVariants.define("cotan", 3, 3);
    public static final PaintingVariant WANDERER = PaintingVariants.define("wanderer", 1, 2);
    public static final PaintingVariant UNPACKED = PaintingVariants.define("unpacked", 4, 4);
    public static final PaintingVariant SUNSET = PaintingVariants.define("sunset", 2, 1);
    public static final PaintingVariant FERN = PaintingVariants.define("fern", 3, 3);
    public static final PaintingVariant BUST = PaintingVariants.define("bust", 2, 2);
    public static final PaintingVariant WIND = PaintingVariants.define("wind", 2, 2);
    public static final PaintingVariant LOWMIST = PaintingVariants.define("lowmist", 4, 2);
    public static final PaintingVariant PASSAGE = PaintingVariants.define("passage", 4, 2);
    public static final PaintingVariant SUNFLOWERS = PaintingVariants.define("sunflowers", 3, 3);
    public static final PaintingVariant GRAHAM = PaintingVariants.define("graham", 1, 2);
    public static final PaintingVariant WASTELAND = PaintingVariants.define("wasteland", 1, 1);
    public static final PaintingVariant SKULL_AND_ROSES = PaintingVariants.define("skull_and_roses", 2, 2);
    public static final PaintingVariant BOUQUET = PaintingVariants.define("bouquet", 3, 3);
    public static final PaintingVariant ORB = PaintingVariants.define("orb", 4, 4);
    public static final PaintingVariant BOMB = PaintingVariants.define("bomb", 1, 1);
    public static final PaintingVariant WITHER = PaintingVariants.define("wither", 2, 2);
    public static final PaintingVariant BACKYARD = PaintingVariants.define("backyard", 3, 4);
    public static final PaintingVariant ENDBOSS = PaintingVariants.define("endboss", 3, 3);
    public static final PaintingVariant MEDITATIVE = PaintingVariants.define("meditative", 1, 1);
    public static final PaintingVariant VOID = PaintingVariants.define("void", 2, 2);
    public static final PaintingVariant KEBAB = PaintingVariants.define("kebab", 1, 1);
    public static final PaintingVariant SEA = PaintingVariants.define("sea", 2, 1);
    public static final PaintingVariant DONKEY_KONG = PaintingVariants.define("donkey_kong", 4, 3);
    public static final PaintingVariant BAROQUE = PaintingVariants.define("baroque", 2, 2);
    public static final PaintingVariant STAGE = PaintingVariants.define("stage", 2, 2);
    public static final PaintingVariant AZTEC = PaintingVariants.define("aztec", 1, 1);
    public static final PaintingVariant PLANT = PaintingVariants.define("plant", 1, 1);
    public static final PaintingVariant CAVEBIRD = PaintingVariants.define("cavebird", 3, 3);
    public static final PaintingVariant COURBET = PaintingVariants.define("courbet", 2, 1);
    public static final PaintingVariant OWLEMONS = PaintingVariants.define("owlemons", 3, 3);

    public static PaintingVariant define(String key, int width, int height) {
        ResourceLocation assetId = ResourceLocation.minecraft(key);
        return PaintingVariants.define(key, width, height, assetId);
    }

    public static PaintingVariant define(String key, final int width, final int height, final ResourceLocation assetId) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        PaintingVariant variant = new PaintingVariant(){

            @Override
            public int getWidth() {
                return width;
            }

            @Override
            public int getHeight() {
                return height;
            }

            @Override
            public ResourceLocation getAssetId() {
                return assetId;
            }

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                return TYPES_BUILDER.getDataIndex(version);
            }

            public boolean equals(Object obj) {
                if (obj instanceof PaintingVariant) {
                    return this.getName().equals(((PaintingVariant)obj).getName());
                }
                return false;
            }
        };
        MappingHelper.registerMapping(TYPES_BUILDER, PAINTING_TYPE_MAP, PAINTING_TYPE_ID_MAP, variant);
        return variant;
    }

    public static PaintingVariant getByName(String name) {
        return PAINTING_TYPE_MAP.get(name);
    }

    public static PaintingVariant getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, PaintingVariant> idMap = PAINTING_TYPE_ID_MAP.get((byte)index);
        return idMap.get(id);
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }
}

