/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.stats;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEvents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBT;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTCompound;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTString;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.stats.Statistic;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.adventure.AdventureSerializer;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.MappingHelper;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.Component;
import java.util.HashMap;
import java.util.Map;

public class Statistics {
    private static final Map<String, Statistic> STATISTIC_MAP = new HashMap<String, Statistic>();

    public static Statistic getById(String id) {
        return STATISTIC_MAP.get(id);
    }

    static {
        ServerVersion version = PacketEvents.getAPI().getServerManager().getVersion();
        if (version.isOlderThan(ServerVersion.V_1_12_2)) {
            NBTCompound mapping = MappingHelper.decompress("mappings/stats/statistics");
            mapping = version.isOlderThanOrEquals(ServerVersion.V_1_8_3) ? mapping.getCompoundTagOrThrow("V_1_8") : mapping.getCompoundTagOrThrow("V_1_12");
            for (final Map.Entry<String, NBT> entry : mapping.getTags().entrySet()) {
                final Component value = AdventureSerializer.parseComponent(((NBTString)entry.getValue()).getValue());
                Statistic statistic = new Statistic(){

                    @Override
                    public String getId() {
                        return (String)entry.getKey();
                    }

                    @Override
                    public Component display() {
                        return value;
                    }

                    public boolean equals(Object obj) {
                        if (obj instanceof Statistic) {
                            return ((Statistic)obj).getId().equals(this.getId());
                        }
                        return false;
                    }
                };
                STATISTIC_MAP.put(entry.getKey(), statistic);
            }
        }
    }
}

