/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.sound;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.mapper.MappedEntity;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.sound.Sounds;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.sound.StaticSound;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface Sound
extends MappedEntity {
    public ResourceLocation getSoundId();

    @Nullable
    public Float getRange();

    public static Sound read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(Sounds::getById, Sound::readDirect);
    }

    public static Sound readDirect(PacketWrapper<?> wrapper) {
        ResourceLocation soundId = wrapper.readIdentifier();
        Float range = (Float)wrapper.readOptional(PacketWrapper::readFloat);
        return new StaticSound(soundId, range);
    }

    public static void write(PacketWrapper<?> wrapper, Sound sound) {
        wrapper.writeMappedEntityOrDirect(sound, Sound::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, Sound sound) {
        wrapper.writeIdentifier(sound.getSoundId());
        wrapper.writeOptional(sound.getRange(), PacketWrapper::writeFloat);
    }
}

