/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.score;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.score.BlankScoreFormat;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.score.FixedScoreFormat;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.score.ScoreFormat;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.score.ScoreFormatType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.score.StyledScoreFormat;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class ScoreFormatTypes {
    private static final Map<String, ScoreFormatType> SCORE_FORMAT_TYPE_MAP = new HashMap<String, ScoreFormatType>();
    private static final Map<Byte, ScoreFormatType> SCORE_FORMAT_TYPE_ID_MAP = new HashMap<Byte, ScoreFormatType>();
    public static final ScoreFormatType BLANK = ScoreFormatTypes.define(0, "blank", BlankScoreFormat.class, wrapper -> ScoreFormat.blankScore(), (wrapper, format) -> {});
    public static final ScoreFormatType STYLED = ScoreFormatTypes.define(1, "styled", StyledScoreFormat.class, wrapper -> ScoreFormat.styledScore(wrapper.readStyle()), (wrapper, format) -> wrapper.writeStyle(format.getStyle()));
    public static final ScoreFormatType FIXED = ScoreFormatTypes.define(2, "fixed", FixedScoreFormat.class, wrapper -> ScoreFormat.fixedScore(wrapper.readComponent()), (wrapper, format) -> wrapper.writeComponent(format.getValue()));

    public static Collection<ScoreFormatType> values() {
        return Collections.unmodifiableCollection(SCORE_FORMAT_TYPE_MAP.values());
    }

    private ScoreFormatTypes() {
    }

    public static ScoreFormat read(PacketWrapper<?> wrapper) {
        int formatTypeId = wrapper.readVarInt();
        ScoreFormatType formatType = ScoreFormatTypes.getById(wrapper.getServerVersion().toClientVersion(), formatTypeId);
        if (formatType == null) {
            throw new NullPointerException("Can't resolve format type " + formatTypeId);
        }
        return formatType.read(wrapper);
    }

    public static void write(PacketWrapper<?> wrapper, ScoreFormat format) {
        int formatTypeId = format.getType().getId(wrapper.getServerVersion().toClientVersion());
        wrapper.writeVarInt(formatTypeId);
        format.getType().write(wrapper, format);
    }

    public static <T extends ScoreFormat> ScoreFormatType define(final int id, String name, final Class<T> formatClass, final Function<PacketWrapper<?>, T> reader, final BiConsumer<PacketWrapper<?>, T> writer) {
        final ResourceLocation location = new ResourceLocation(name);
        ScoreFormatType type = new ScoreFormatType(){

            @Override
            public ScoreFormat read(PacketWrapper<?> wrapper) {
                return (ScoreFormat)reader.apply(wrapper);
            }

            @Override
            public void write(PacketWrapper<?> wrapper, ScoreFormat format) {
                writer.accept(wrapper, (ScoreFormat)formatClass.cast(format));
            }

            @Override
            public ResourceLocation getName() {
                return location;
            }

            @Override
            public int getId() {
                return id;
            }
        };
        SCORE_FORMAT_TYPE_MAP.put(location.toString(), type);
        SCORE_FORMAT_TYPE_ID_MAP.put((byte)id, type);
        return type;
    }

    @Nullable
    public static ScoreFormatType getById(ClientVersion version, int id) {
        return SCORE_FORMAT_TYPE_ID_MAP.get((byte)id);
    }

    @Nullable
    public static ScoreFormatType getByName(String name) {
        return ScoreFormatTypes.getByName(new ResourceLocation(name));
    }

    @Nullable
    public static ScoreFormatType getByName(ResourceLocation name) {
        return SCORE_FORMAT_TYPE_MAP.get(name.toString());
    }
}

