/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.recipe;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.recipe.RecipeSerializer;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.recipe.RecipeType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.recipe.data.CookedRecipeData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.recipe.data.RecipeData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.recipe.data.ShapedRecipeData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.recipe.data.ShapelessRecipeData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.recipe.data.SimpleRecipeData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.recipe.data.SmithingRecipeData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.recipe.data.SmithingTrimRecipeData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.recipe.data.StoneCuttingRecipeData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.MappingHelper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilder;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilderData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class RecipeSerializers {
    private static final Map<String, RecipeSerializer<?>> PATTERN_TYPE_MAP = new HashMap();
    private static final Map<Byte, Map<Integer, RecipeSerializer<?>>> PATTERN_TYPE_ID_MAP = new HashMap();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("item/recipe_serializer_mappings");
    public static final RecipeSerializer<ShapedRecipeData> CRAFTING_SHAPED = RecipeSerializers.define("crafting_shaped", ShapedRecipeData::read, ShapedRecipeData::write, RecipeType.CRAFTING_SHAPED);
    public static final RecipeSerializer<ShapelessRecipeData> CRAFTING_SHAPELESS = RecipeSerializers.define("crafting_shapeless", ShapelessRecipeData::read, ShapelessRecipeData::write, RecipeType.CRAFTING_SHAPELESS);
    public static final RecipeSerializer<SimpleRecipeData> CRAFTING_SPECIAL_ARMORDYE = RecipeSerializers.define("crafting_special_armordye", SimpleRecipeData::read, SimpleRecipeData::write, RecipeType.CRAFTING_SPECIAL_ARMORDYE);
    public static final RecipeSerializer<SimpleRecipeData> CRAFTING_SPECIAL_BOOKCLONING = RecipeSerializers.define("crafting_special_bookcloning", SimpleRecipeData::read, SimpleRecipeData::write, RecipeType.CRAFTING_SPECIAL_BOOKCLONING);
    public static final RecipeSerializer<SimpleRecipeData> CRAFTING_SPECIAL_MAPCLONING = RecipeSerializers.define("crafting_special_mapcloning", SimpleRecipeData::read, SimpleRecipeData::write, RecipeType.CRAFTING_SPECIAL_MAPCLONING);
    public static final RecipeSerializer<SimpleRecipeData> CRAFTING_SPECIAL_MAPEXTENDING = RecipeSerializers.define("crafting_special_mapextending", SimpleRecipeData::read, SimpleRecipeData::write, RecipeType.CRAFTING_SPECIAL_MAPEXTENDING);
    public static final RecipeSerializer<SimpleRecipeData> CRAFTING_SPECIAL_FIREWORK_ROCKET = RecipeSerializers.define("crafting_special_firework_rocket", SimpleRecipeData::read, SimpleRecipeData::write, RecipeType.CRAFTING_SPECIAL_FIREWORK_ROCKET);
    public static final RecipeSerializer<SimpleRecipeData> CRAFTING_SPECIAL_FIREWORK_STAR = RecipeSerializers.define("crafting_special_firework_star", SimpleRecipeData::read, SimpleRecipeData::write, RecipeType.CRAFTING_SPECIAL_FIREWORK_STAR);
    public static final RecipeSerializer<SimpleRecipeData> CRAFTING_SPECIAL_FIREWORK_STAR_FADE = RecipeSerializers.define("crafting_special_firework_star_fade", SimpleRecipeData::read, SimpleRecipeData::write, RecipeType.CRAFTING_SPECIAL_FIREWORK_STAR_FADE);
    public static final RecipeSerializer<SimpleRecipeData> CRAFTING_SPECIAL_TIPPEDARROW = RecipeSerializers.define("crafting_special_tippedarrow", SimpleRecipeData::read, SimpleRecipeData::write, RecipeType.CRAFTING_SPECIAL_TIPPEDARROW);
    public static final RecipeSerializer<SimpleRecipeData> CRAFTING_SPECIAL_BANNERDUPLICATE = RecipeSerializers.define("crafting_special_bannerduplicate", SimpleRecipeData::read, SimpleRecipeData::write, RecipeType.CRAFTING_SPECIAL_BANNERDUPLICATE);
    public static final RecipeSerializer<SimpleRecipeData> CRAFTING_SPECIAL_SHIELDDECORATION = RecipeSerializers.define("crafting_special_shielddecoration", SimpleRecipeData::read, SimpleRecipeData::write, RecipeType.CRAFTING_SPECIAL_SHIELDDECORATION);
    public static final RecipeSerializer<SimpleRecipeData> CRAFTING_SPECIAL_SHULKERBOXCOLORING = RecipeSerializers.define("crafting_special_shulkerboxcoloring", SimpleRecipeData::read, SimpleRecipeData::write, RecipeType.CRAFTING_SPECIAL_SHULKERBOXCOLORING);
    public static final RecipeSerializer<SimpleRecipeData> CRAFTING_SPECIAL_SUSPICIOUSSTEW = RecipeSerializers.define("crafting_special_suspiciousstew", SimpleRecipeData::read, SimpleRecipeData::write, RecipeType.CRAFTING_SPECIAL_SUSPICIOUSSTEW);
    public static final RecipeSerializer<SimpleRecipeData> CRAFTING_SPECIAL_REPAIRITEM = RecipeSerializers.define("crafting_special_repairitem", SimpleRecipeData::read, SimpleRecipeData::write, RecipeType.CRAFTING_SPECIAL_REPAIRITEM);
    public static final RecipeSerializer<CookedRecipeData> SMELTING = RecipeSerializers.define("smelting", CookedRecipeData::read, CookedRecipeData::write, RecipeType.SMELTING);
    public static final RecipeSerializer<CookedRecipeData> BLASTING = RecipeSerializers.define("blasting", CookedRecipeData::read, CookedRecipeData::write, RecipeType.BLASTING);
    public static final RecipeSerializer<CookedRecipeData> SMOKING = RecipeSerializers.define("smoking", CookedRecipeData::read, CookedRecipeData::write, RecipeType.SMOKING);
    public static final RecipeSerializer<CookedRecipeData> CAMPFIRE_COOKING = RecipeSerializers.define("campfire_cooking", CookedRecipeData::read, CookedRecipeData::write, RecipeType.CAMPFIRE_COOKING);
    public static final RecipeSerializer<StoneCuttingRecipeData> STONECUTTING = RecipeSerializers.define("stonecutting", StoneCuttingRecipeData::read, StoneCuttingRecipeData::write, RecipeType.STONECUTTING);
    @Deprecated
    public static final RecipeSerializer<SmithingRecipeData> SMITHING = RecipeSerializers.define("smithing_transform", ew -> SmithingRecipeData.read(ew, true), (ew, data) -> SmithingRecipeData.write(ew, data, true), RecipeType.SMITHING);
    public static final RecipeSerializer<SmithingRecipeData> SMITHING_TRANSFORM = RecipeSerializers.define("smithing_transform", SmithingRecipeData::read, SmithingRecipeData::write, RecipeType.SMITHING);
    public static final RecipeSerializer<SmithingTrimRecipeData> SMITHING_TRIM = RecipeSerializers.define("smithing_trim", SmithingTrimRecipeData::read, SmithingTrimRecipeData::write);
    public static final RecipeSerializer<SimpleRecipeData> CRAFTING_DECORATED_POT = RecipeSerializers.define("crafting_decorated_pot", SimpleRecipeData::read, SimpleRecipeData::write);

    public static <T extends RecipeData> RecipeSerializer<T> define(String key, PacketWrapper.Reader<T> reader, PacketWrapper.Writer<T> writer) {
        return RecipeSerializers.define(key, reader, writer, null);
    }

    public static <T extends RecipeData> RecipeSerializer<T> define(String key, final PacketWrapper.Reader<T> reader, final PacketWrapper.Writer<T> writer, final @Nullable RecipeType recipeType) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        RecipeSerializer pattern = new RecipeSerializer<T>(){

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                return MappingHelper.getId(version, TYPES_BUILDER, data);
            }

            @Override
            public RecipeType getLegacyType() {
                if (recipeType == null) {
                    throw new UnsupportedOperationException("No legacy type found for " + this.getName());
                }
                return recipeType;
            }

            @Override
            public T read(PacketWrapper<?> wrapper) {
                return (RecipeData)reader.apply(wrapper);
            }

            @Override
            public void write(PacketWrapper<?> wrapper, T data2) {
                writer.accept(wrapper, data2);
            }

            public boolean equals(Object obj) {
                if (obj instanceof RecipeSerializer) {
                    return this.getName().equals(((RecipeSerializer)obj).getName());
                }
                return false;
            }
        };
        MappingHelper.registerMapping(TYPES_BUILDER, PATTERN_TYPE_MAP, PATTERN_TYPE_ID_MAP, pattern);
        return pattern;
    }

    public static RecipeSerializer<?> getByName(String name) {
        return PATTERN_TYPE_MAP.get(name);
    }

    public static RecipeSerializer<?> getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, RecipeSerializer<?>> idMap = PATTERN_TYPE_ID_MAP.get((byte)index);
        return idMap.get(id);
    }

    public static Collection<RecipeSerializer<?>> values() {
        return Collections.unmodifiableCollection(PATTERN_TYPE_MAP.values());
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }
}

