/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.data;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.ItemStack;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.type.ItemTypes;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.data.LegacyConvertible;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.data.LegacyParticleData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.data.ParticleData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;

public class ParticleItemStackData
extends ParticleData
implements LegacyConvertible {
    private ItemStack itemStack;

    public ParticleItemStackData(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public static ParticleItemStackData read(PacketWrapper<?> wrapper) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_13)) {
            return new ParticleItemStackData(wrapper.readItemStack());
        }
        return new ParticleItemStackData(ItemStack.builder().type(ItemTypes.getById(wrapper.getClientVersion(), wrapper.readVarInt())).build());
    }

    public static void write(PacketWrapper<?> wrapper, ParticleItemStackData data) {
        wrapper.writeItemStack(data.getItemStack());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public LegacyParticleData toLegacy(ClientVersion version) {
        return LegacyParticleData.ofTwo(this.itemStack.getType().getId(version), this.itemStack.getLegacyData());
    }
}

