/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.data;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.color.Color;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.data.ParticleData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.Vector3f;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;

public class ParticleDustColorTransitionData
extends ParticleData {
    private float scale;
    private float startRed;
    private float startGreen;
    private float startBlue;
    private float endRed;
    private float endGreen;
    private float endBlue;

    public ParticleDustColorTransitionData(float scale, float startRed, float startGreen, float startBlue, float endRed, float endGreen, float endBlue) {
        this.scale = scale;
        this.startRed = startRed;
        this.startGreen = startGreen;
        this.startBlue = startBlue;
        this.endRed = endRed;
        this.endGreen = endGreen;
        this.endBlue = endBlue;
    }

    public ParticleDustColorTransitionData(float scale, Vector3f startRGB, Vector3f endRGB) {
        this(scale, startRGB.getX(), startRGB.getY(), startRGB.getZ(), endRGB.getX(), endRGB.getY(), endRGB.getZ());
    }

    public ParticleDustColorTransitionData(float scale, Color start, Color end) {
        this(scale, (float)start.red() / 255.0f, (float)start.green() / 255.0f, (float)start.blue() / 255.0f, (float)end.red() / 255.0f, (float)end.green() / 255.0f, (float)end.blue() / 255.0f);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getStartRed() {
        return this.startRed;
    }

    public void setStartRed(float startRed) {
        this.startRed = startRed;
    }

    public float getStartGreen() {
        return this.startGreen;
    }

    public void setStartGreen(float startGreen) {
        this.startGreen = startGreen;
    }

    public float getStartBlue() {
        return this.startBlue;
    }

    public void setStartBlue(float startBlue) {
        this.startBlue = startBlue;
    }

    public float getEndRed() {
        return this.endRed;
    }

    public void setEndRed(float endRed) {
        this.endRed = endRed;
    }

    public float getEndGreen() {
        return this.endGreen;
    }

    public void setEndGreen(float endGreen) {
        this.endGreen = endGreen;
    }

    public float getEndBlue() {
        return this.endBlue;
    }

    public void setEndBlue(float endBlue) {
        this.endBlue = endBlue;
    }

    public static ParticleDustColorTransitionData read(PacketWrapper<?> wrapper) {
        float startRed = wrapper.readFloat();
        float startGreen = wrapper.readFloat();
        float startBlue = wrapper.readFloat();
        float scale = 0.0f;
        if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_20_5)) {
            scale = wrapper.readFloat();
        }
        float endRed = wrapper.readFloat();
        float endGreen = wrapper.readFloat();
        float endBlue = wrapper.readFloat();
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            scale = wrapper.readFloat();
        }
        return new ParticleDustColorTransitionData(scale, startRed, startGreen, startBlue, endRed, endGreen, endBlue);
    }

    public static void write(PacketWrapper<?> wrapper, ParticleDustColorTransitionData data) {
        wrapper.writeFloat(data.getStartRed());
        wrapper.writeFloat(data.getStartGreen());
        wrapper.writeFloat(data.getStartBlue());
        if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_20_5)) {
            wrapper.writeFloat(data.getScale());
        }
        wrapper.writeFloat(data.getEndRed());
        wrapper.writeFloat(data.getEndGreen());
        wrapper.writeFloat(data.getEndBlue());
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            wrapper.writeFloat(data.getScale());
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

