/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.netty.buffer.ByteBufHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTLimiter {
    private final int max;
    @Nullable
    private Object byteBuf;
    private int bytes;

    public NBTLimiter() {
        this.max = Integer.MAX_VALUE;
    }

    public NBTLimiter(@NotNull Object byteBuf) {
        this.byteBuf = byteBuf;
        this.max = 0x200000;
    }

    public void increment(int amount) {
        this.bytes += amount;
        if (this.bytes > this.max) {
            throw new IllegalArgumentException("NBT size limit reached (" + this.bytes + "/" + this.max + ")");
        }
    }

    public void checkReadability(int length) {
        if (this.byteBuf != null && length > ByteBufHelper.readableBytes(this.byteBuf)) {
            throw new IllegalArgumentException("Length is too large: " + length + ", readable: " + ByteBufHelper.readableBytes(this.byteBuf));
        }
    }
}

