/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.mapper;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.mapper.MappedEntity;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nullable;

public class MappedEntitySet<T> {
    @Nullable
    private final ResourceLocation tagKey;
    @Nullable
    private final List<T> entities;

    public MappedEntitySet(ResourceLocation tagKey) {
        this(tagKey, null);
    }

    public MappedEntitySet(List<T> entities) {
        this(null, entities);
    }

    public MappedEntitySet(@Nullable ResourceLocation tagKey, @Nullable List<T> entities) {
        if (tagKey == null && entities == null) {
            throw new IllegalArgumentException("Illegal generic holder set: either tag key or holder ids have to be set");
        }
        this.tagKey = tagKey;
        this.entities = entities;
    }

    public static <Z extends MappedEntity> MappedEntitySet<Z> read(PacketWrapper<?> wrapper, BiFunction<ClientVersion, Integer, Z> getter) {
        int count = wrapper.readVarInt() - 1;
        if (count == -1) {
            return new MappedEntitySet(wrapper.readIdentifier(), null);
        }
        ArrayList<Z> entities = new ArrayList<Z>(Math.min(count, 65536));
        for (int i = 0; i < count; ++i) {
            entities.add(wrapper.readMappedEntity(getter));
        }
        return new MappedEntitySet(null, entities);
    }

    public static <Z extends MappedEntity> void write(PacketWrapper<?> wrapper, MappedEntitySet<Z> set) {
        if (set.tagKey != null) {
            wrapper.writeByte(0);
            wrapper.writeIdentifier(set.tagKey);
            return;
        }
        assert (set.entities != null);
        wrapper.writeVarInt(set.entities.size() + 1);
        for (MappedEntity entity : set.entities) {
            wrapper.writeMappedEntity(entity);
        }
    }
}

