/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.trimpattern;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.trimpattern.TrimPattern;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.type.ItemType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.type.ItemTypes;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.MappingHelper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilder;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilderData;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.Component;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.TranslatableComponent;
import java.util.HashMap;
import java.util.Map;

public class TrimPatterns {
    private static final Map<String, TrimPattern> PATTERN_TYPE_MAP = new HashMap<String, TrimPattern>();
    private static final Map<Byte, Map<Integer, TrimPattern>> PATTERN_TYPE_ID_MAP = new HashMap<Byte, Map<Integer, TrimPattern>>();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("item/item_trim_pattern_mappings");
    public static final TrimPattern COAST = TrimPatterns.define("coast");
    public static final TrimPattern DUNE = TrimPatterns.define("dune");
    public static final TrimPattern EYE = TrimPatterns.define("eye");
    public static final TrimPattern RIB = TrimPatterns.define("rib");
    public static final TrimPattern SENTRY = TrimPatterns.define("sentry");
    public static final TrimPattern SNOUT = TrimPatterns.define("snout");
    public static final TrimPattern SPIRE = TrimPatterns.define("spire");
    public static final TrimPattern TIDE = TrimPatterns.define("tide");
    public static final TrimPattern VEX = TrimPatterns.define("vex");
    public static final TrimPattern WARD = TrimPatterns.define("ward");
    public static final TrimPattern WILD = TrimPatterns.define("wild");
    public static final TrimPattern RAISER = TrimPatterns.define("raiser");
    public static final TrimPattern HOST = TrimPatterns.define("host");
    public static final TrimPattern SILENCE = TrimPatterns.define("silence");
    public static final TrimPattern SHAPER = TrimPatterns.define("shaper");
    public static final TrimPattern WAYFINDER = TrimPatterns.define("wayfinder");
    public static final TrimPattern BOLT = TrimPatterns.define("bolt");
    public static final TrimPattern FLOW = TrimPatterns.define("flow");

    public static TrimPattern define(String key) {
        ResourceLocation assetId = ResourceLocation.minecraft(key);
        ItemType templateItem = ItemTypes.getByName(assetId + "_armor_trim_smithing_template");
        TranslatableComponent description = Component.translatable("trim_pattern.minecraft." + key);
        boolean decal = false;
        return TrimPatterns.define(key, assetId, templateItem, description, decal);
    }

    public static TrimPattern define(String key, final ResourceLocation assetId, final ItemType templateItem, final Component description, final boolean decal) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        TrimPattern pattern = new TrimPattern(){

            @Override
            public ResourceLocation getAssetId() {
                return assetId;
            }

            @Override
            public ItemType getTemplateItem() {
                return templateItem;
            }

            @Override
            public Component getDescription() {
                return description;
            }

            @Override
            public boolean isDecal() {
                return decal;
            }

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                return MappingHelper.getId(version, TYPES_BUILDER, data);
            }

            public boolean equals(Object obj) {
                if (obj instanceof TrimPattern) {
                    return this.getName().equals(((TrimPattern)obj).getName());
                }
                return false;
            }
        };
        MappingHelper.registerMapping(TYPES_BUILDER, PATTERN_TYPE_MAP, PATTERN_TYPE_ID_MAP, pattern);
        return pattern;
    }

    public static TrimPattern getByName(String name) {
        return PATTERN_TYPE_MAP.get(name);
    }

    public static TrimPattern getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, TrimPattern> idMap = PATTERN_TYPE_ID_MAP.get((byte)index);
        return idMap.get(id);
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }
}

