/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.trimmaterial;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.armormaterial.ArmorMaterial;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.armormaterial.ArmorMaterials;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.trimmaterial.TrimMaterial;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.type.ItemType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.type.ItemTypes;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.MappingHelper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilder;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilderData;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.Component;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.TranslatableComponent;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.format.TextColor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TrimMaterials {
    private static final Map<String, TrimMaterial> TRIM_MATERIAL_MAP = new HashMap<String, TrimMaterial>();
    private static final Map<Byte, Map<Integer, TrimMaterial>> TRIM_MATERIAL_ID_MAP = new HashMap<Byte, Map<Integer, TrimMaterial>>();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("item/item_trim_material_mappings");
    public static final TrimMaterial AMETHYST = TrimMaterials.define("amethyst", ItemTypes.AMETHYST_SHARD, 1.0f, 10116294);
    public static final TrimMaterial COPPER = TrimMaterials.define("copper", ItemTypes.COPPER_INGOT, 0.5f, 11823181);
    public static final TrimMaterial DIAMOND = TrimMaterials.define("diamond", ItemTypes.DIAMOND, 0.8f, 7269586);
    public static final TrimMaterial EMERALD = TrimMaterials.define("emerald", ItemTypes.EMERALD, 0.7f, 1155126);
    public static final TrimMaterial GOLD = TrimMaterials.define("gold", ItemTypes.GOLD_INGOT, 0.6f, 14594349);
    public static final TrimMaterial IRON = TrimMaterials.define("iron", ItemTypes.IRON_INGOT, 0.2f, 0xECECEC);
    public static final TrimMaterial LAPIS = TrimMaterials.define("lapis", ItemTypes.LAPIS_LAZULI, 0.9f, 4288151);
    public static final TrimMaterial NETHERITE = TrimMaterials.define("netherite", ItemTypes.NETHERITE_INGOT, 0.3f, 6445145);
    public static final TrimMaterial QUARTZ = TrimMaterials.define("quartz", ItemTypes.QUARTZ, 0.1f, 14931140);
    public static final TrimMaterial REDSTONE = TrimMaterials.define("redstone", ItemTypes.REDSTONE, 0.4f, 9901575);

    public static TrimMaterial define(String key, ItemType ingredient, float itemModelIndex, int color) {
        HashMap<ArmorMaterial, String> overrideArmorMaterials = new HashMap<ArmorMaterial, String>(2);
        String armorMaterialId = ResourceLocation.minecraft(key).toString();
        ArmorMaterial armorMaterial = ArmorMaterials.getByName(armorMaterialId);
        if (armorMaterial != null) {
            overrideArmorMaterials.put(armorMaterial, key + "_darker");
        }
        TranslatableComponent description = Component.translatable("trim_material.minecraft." + key, TextColor.color(color));
        return TrimMaterials.define(key, key, ingredient, itemModelIndex, overrideArmorMaterials, description);
    }

    public static TrimMaterial define(String key, final String assetName, final ItemType ingredient, final float itemModelIndex, final Map<ArmorMaterial, String> overrideArmorMaterials, final Component description) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        TrimMaterial material = new TrimMaterial(){

            @Override
            public String getAssetName() {
                return assetName;
            }

            @Override
            public ItemType getIngredient() {
                return ingredient;
            }

            @Override
            public float getItemModelIndex() {
                return itemModelIndex;
            }

            @Override
            public Map<ArmorMaterial, String> getOverrideArmorMaterials() {
                return overrideArmorMaterials;
            }

            @Override
            public Component getDescription() {
                return description;
            }

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                return MappingHelper.getId(version, TYPES_BUILDER, data);
            }

            public boolean equals(Object obj) {
                if (obj instanceof TrimMaterial) {
                    return this.getName().equals(((TrimMaterial)obj).getName());
                }
                return false;
            }
        };
        MappingHelper.registerMapping(TYPES_BUILDER, TRIM_MATERIAL_MAP, TRIM_MATERIAL_ID_MAP, material);
        return material;
    }

    public static TrimMaterial getByName(String name) {
        return TRIM_MATERIAL_MAP.get(name);
    }

    public static TrimMaterial getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, TrimMaterial> idMap = TRIM_MATERIAL_ID_MAP.get((byte)index);
        return idMap.get(id);
    }

    public static Collection<TrimMaterial> values() {
        return Collections.unmodifiableCollection(TRIM_MATERIAL_MAP.values());
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }
}

