/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.trimmaterial;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.armormaterial.ArmorMaterial;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.armormaterial.ArmorMaterials;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.trimmaterial.StaticTrimMaterial;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.trimmaterial.TrimMaterials;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.type.ItemType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.type.ItemTypes;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.mapper.MappedEntity;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.Component;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public interface TrimMaterial
extends MappedEntity {
    public String getAssetName();

    public ItemType getIngredient();

    public float getItemModelIndex();

    @Nullable
    default public String getArmorMaterialOverride(ArmorMaterial armorMaterial) {
        return this.getOverrideArmorMaterials().get(armorMaterial);
    }

    public Map<ArmorMaterial, String> getOverrideArmorMaterials();

    public Component getDescription();

    public static TrimMaterial read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(TrimMaterials::getById, TrimMaterial::readDirect);
    }

    public static TrimMaterial readDirect(PacketWrapper<?> wrapper) {
        String assetName = wrapper.readString();
        ItemType ingredient = wrapper.readMappedEntity(ItemTypes::getById);
        float itemModelIndex = wrapper.readFloat();
        Map<ArmorMaterial, String> overrideArmorMaterials = wrapper.readMap(ew -> ew.readMappedEntity(ArmorMaterials::getById), PacketWrapper::readString);
        Component description = wrapper.readComponent();
        return new StaticTrimMaterial(assetName, ingredient, itemModelIndex, overrideArmorMaterials, description);
    }

    public static void write(PacketWrapper<?> wrapper, TrimMaterial material) {
        wrapper.writeMappedEntityOrDirect(material, TrimMaterial::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, TrimMaterial material) {
        wrapper.writeString(material.getAssetName());
        wrapper.writeMappedEntity(material.getIngredient());
        wrapper.writeFloat(material.getItemModelIndex());
        wrapper.writeMap(material.getOverrideArmorMaterials(), PacketWrapper::writeMappedEntity, PacketWrapper::writeString);
        wrapper.writeComponent(material.getDescription());
    }
}

