/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.jukebox;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.sound.Sound;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.Component;
import java.util.Objects;

public class JukeboxSong {
    private Sound sound;
    private Component description;
    private float lengthInSeconds;
    private int comparatorOutput;

    public JukeboxSong(Sound sound, Component description, float lengthInSeconds, int comparatorOutput) {
        this.sound = sound;
        this.description = description;
        this.lengthInSeconds = lengthInSeconds;
        this.comparatorOutput = comparatorOutput;
    }

    public static JukeboxSong read(PacketWrapper<?> wrapper) {
        Sound sound = Sound.read(wrapper);
        Component description = wrapper.readComponent();
        float lengthInSeconds = wrapper.readFloat();
        int comparatorOutput = wrapper.readVarInt();
        return new JukeboxSong(sound, description, lengthInSeconds, comparatorOutput);
    }

    public static void write(PacketWrapper<?> wrapper, JukeboxSong song) {
        Sound.write(wrapper, song.sound);
        wrapper.writeComponent(song.description);
        wrapper.writeFloat(song.lengthInSeconds);
        wrapper.writeVarInt(song.comparatorOutput);
    }

    public Sound getSound() {
        return this.sound;
    }

    public void setSound(Sound sound) {
        this.sound = sound;
    }

    public Component getDescription() {
        return this.description;
    }

    public void setDescription(Component description) {
        this.description = description;
    }

    public float getLengthInSeconds() {
        return this.lengthInSeconds;
    }

    public void setLengthInSeconds(float lengthInSeconds) {
        this.lengthInSeconds = lengthInSeconds;
    }

    public int getComparatorOutput() {
        return this.comparatorOutput;
    }

    public void setComparatorOutput(int comparatorOutput) {
        this.comparatorOutput = comparatorOutput;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JukeboxSong)) {
            return false;
        }
        JukeboxSong that = (JukeboxSong)obj;
        if (Float.compare(that.lengthInSeconds, this.lengthInSeconds) != 0) {
            return false;
        }
        if (this.comparatorOutput != that.comparatorOutput) {
            return false;
        }
        if (!this.sound.equals(that.sound)) {
            return false;
        }
        return this.description.equals(that.description);
    }

    public int hashCode() {
        return Objects.hash(this.sound, this.description, Float.valueOf(this.lengthInSeconds), this.comparatorOutput);
    }
}

