/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.instrument;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.instrument.Instruments;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.instrument.StaticInstrument;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.mapper.MappedEntity;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.sound.Sound;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;

public interface Instrument
extends MappedEntity {
    public Sound getSound();

    public int getUseDuration();

    public float getRange();

    public static Instrument read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(Instruments::getById, Instrument::readDirect);
    }

    public static Instrument readDirect(PacketWrapper<?> wrapper) {
        Sound sound = Sound.read(wrapper);
        int useDuration = wrapper.readVarInt();
        float range = wrapper.readFloat();
        return new StaticInstrument(sound, useDuration, range);
    }

    public static void write(PacketWrapper<?> wrapper, Instrument instrument) {
        wrapper.writeMappedEntityOrDirect(instrument, Instrument::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, Instrument instrument) {
        Sound.write(wrapper, instrument.getSound());
        wrapper.writeVarInt(instrument.getUseDuration());
        wrapper.writeFloat(instrument.getRange());
    }
}

