/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.enchantment.type;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.enchantment.type.EnchantmentType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.MappingHelper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilder;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilderData;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class EnchantmentTypes {
    private static final Map<String, String> STRING_UPDATER = new HashMap<String, String>();
    private static final Map<String, EnchantmentType> ENCHANTMENT_TYPE_MAPPINGS;
    private static final Map<Byte, Map<Integer, EnchantmentType>> ENCHANTMENT_TYPE_ID_MAPPINGS;
    private static final TypesBuilder TYPES_BUILDER;
    public static final EnchantmentType ALL_DAMAGE_PROTECTION;
    public static final EnchantmentType FIRE_PROTECTION;
    public static final EnchantmentType FALL_PROTECTION;
    public static final EnchantmentType BLAST_PROTECTION;
    public static final EnchantmentType PROJECTILE_PROTECTION;
    public static final EnchantmentType RESPIRATION;
    public static final EnchantmentType AQUA_AFFINITY;
    public static final EnchantmentType THORNS;
    public static final EnchantmentType DEPTH_STRIDER;
    public static final EnchantmentType FROST_WALKER;
    public static final EnchantmentType BINDING_CURSE;
    public static final EnchantmentType SOUL_SPEED;
    public static final EnchantmentType SWIFT_SNEAK;
    public static final EnchantmentType SHARPNESS;
    public static final EnchantmentType SMITE;
    public static final EnchantmentType BANE_OF_ARTHROPODS;
    public static final EnchantmentType KNOCKBACK;
    public static final EnchantmentType FIRE_ASPECT;
    public static final EnchantmentType MOB_LOOTING;
    public static final EnchantmentType SWEEPING_EDGE;
    public static final EnchantmentType BLOCK_EFFICIENCY;
    public static final EnchantmentType SILK_TOUCH;
    public static final EnchantmentType UNBREAKING;
    public static final EnchantmentType BLOCK_FORTUNE;
    public static final EnchantmentType POWER_ARROWS;
    public static final EnchantmentType PUNCH_ARROWS;
    public static final EnchantmentType FLAMING_ARROWS;
    public static final EnchantmentType INFINITY_ARROWS;
    public static final EnchantmentType FISHING_LUCK;
    public static final EnchantmentType FISHING_SPEED;
    public static final EnchantmentType LOYALTY;
    public static final EnchantmentType IMPALING;
    public static final EnchantmentType RIPTIDE;
    public static final EnchantmentType CHANNELING;
    public static final EnchantmentType MULTISHOT;
    public static final EnchantmentType QUICK_CHARGE;
    public static final EnchantmentType PIERCING;
    public static final EnchantmentType MENDING;
    public static final EnchantmentType VANISHING_CURSE;
    public static final EnchantmentType DENSITY;
    public static final EnchantmentType BREACH;
    public static final EnchantmentType WIND_BURST;

    public static EnchantmentType define(String key) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        EnchantmentType enchantmentType = new EnchantmentType(){

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                return MappingHelper.getId(version, TYPES_BUILDER, data);
            }

            public boolean equals(Object obj) {
                if (obj instanceof EnchantmentType) {
                    return this.getName() == ((EnchantmentType)obj).getName();
                }
                return false;
            }
        };
        MappingHelper.registerMapping(TYPES_BUILDER, ENCHANTMENT_TYPE_MAPPINGS, ENCHANTMENT_TYPE_ID_MAPPINGS, enchantmentType);
        return enchantmentType;
    }

    @Nullable
    public static EnchantmentType getByName(String name) {
        String fixedName = STRING_UPDATER.getOrDefault(name, name);
        return ENCHANTMENT_TYPE_MAPPINGS.get(fixedName);
    }

    @Nullable
    public static EnchantmentType getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, EnchantmentType> typeIdMap = ENCHANTMENT_TYPE_ID_MAPPINGS.get((byte)index);
        return typeIdMap.get(id);
    }

    static {
        STRING_UPDATER.put("minecraft:sweeping", "minecraft:sweeping_edge");
        ENCHANTMENT_TYPE_MAPPINGS = new HashMap<String, EnchantmentType>();
        ENCHANTMENT_TYPE_ID_MAPPINGS = new HashMap<Byte, Map<Integer, EnchantmentType>>();
        TYPES_BUILDER = new TypesBuilder("enchantment/enchantment_type_mappings");
        ALL_DAMAGE_PROTECTION = EnchantmentTypes.define("protection");
        FIRE_PROTECTION = EnchantmentTypes.define("fire_protection");
        FALL_PROTECTION = EnchantmentTypes.define("feather_falling");
        BLAST_PROTECTION = EnchantmentTypes.define("blast_protection");
        PROJECTILE_PROTECTION = EnchantmentTypes.define("projectile_protection");
        RESPIRATION = EnchantmentTypes.define("respiration");
        AQUA_AFFINITY = EnchantmentTypes.define("aqua_affinity");
        THORNS = EnchantmentTypes.define("thorns");
        DEPTH_STRIDER = EnchantmentTypes.define("depth_strider");
        FROST_WALKER = EnchantmentTypes.define("frost_walker");
        BINDING_CURSE = EnchantmentTypes.define("binding_curse");
        SOUL_SPEED = EnchantmentTypes.define("soul_speed");
        SWIFT_SNEAK = EnchantmentTypes.define("swift_sneak");
        SHARPNESS = EnchantmentTypes.define("sharpness");
        SMITE = EnchantmentTypes.define("smite");
        BANE_OF_ARTHROPODS = EnchantmentTypes.define("bane_of_arthropods");
        KNOCKBACK = EnchantmentTypes.define("knockback");
        FIRE_ASPECT = EnchantmentTypes.define("fire_aspect");
        MOB_LOOTING = EnchantmentTypes.define("looting");
        SWEEPING_EDGE = EnchantmentTypes.define("sweeping_edge");
        BLOCK_EFFICIENCY = EnchantmentTypes.define("efficiency");
        SILK_TOUCH = EnchantmentTypes.define("silk_touch");
        UNBREAKING = EnchantmentTypes.define("unbreaking");
        BLOCK_FORTUNE = EnchantmentTypes.define("fortune");
        POWER_ARROWS = EnchantmentTypes.define("power");
        PUNCH_ARROWS = EnchantmentTypes.define("punch");
        FLAMING_ARROWS = EnchantmentTypes.define("flame");
        INFINITY_ARROWS = EnchantmentTypes.define("infinity");
        FISHING_LUCK = EnchantmentTypes.define("luck_of_the_sea");
        FISHING_SPEED = EnchantmentTypes.define("lure");
        LOYALTY = EnchantmentTypes.define("loyalty");
        IMPALING = EnchantmentTypes.define("impaling");
        RIPTIDE = EnchantmentTypes.define("riptide");
        CHANNELING = EnchantmentTypes.define("channeling");
        MULTISHOT = EnchantmentTypes.define("multishot");
        QUICK_CHARGE = EnchantmentTypes.define("quick_charge");
        PIERCING = EnchantmentTypes.define("piercing");
        MENDING = EnchantmentTypes.define("mending");
        VANISHING_CURSE = EnchantmentTypes.define("vanishing_curse");
        DENSITY = EnchantmentTypes.define("density");
        BREACH = EnchantmentTypes.define("breach");
        WIND_BURST = EnchantmentTypes.define("wind_burst");
        TYPES_BUILDER.unloadFileMappings();
    }
}

