/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.banner;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.banner.BannerPattern;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.MappingHelper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilder;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilderData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BannerPatterns {
    private static final Map<String, BannerPattern> PATTERN_TYPE_MAP = new HashMap<String, BannerPattern>();
    private static final Map<Byte, Map<Integer, BannerPattern>> PATTERN_TYPE_ID_MAP = new HashMap<Byte, Map<Integer, BannerPattern>>();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("item/item_banner_pattern_mappings");
    public static final BannerPattern SQUARE_BOTTOM_LEFT = BannerPatterns.define("square_bottom_left");
    public static final BannerPattern STRIPE_BOTTOM = BannerPatterns.define("stripe_bottom");
    public static final BannerPattern CREEPER = BannerPatterns.define("creeper");
    public static final BannerPattern HALF_HORIZONTAL = BannerPatterns.define("half_horizontal");
    public static final BannerPattern STRIPE_MIDDLE = BannerPatterns.define("stripe_middle");
    public static final BannerPattern BASE = BannerPatterns.define("base");
    public static final BannerPattern DIAGONAL_UP_RIGHT = BannerPatterns.define("diagonal_up_right");
    public static final BannerPattern HALF_HORIZONTAL_BOTTOM = BannerPatterns.define("half_horizontal_bottom");
    public static final BannerPattern SMALL_STRIPES = BannerPatterns.define("small_stripes");
    public static final BannerPattern GRADIENT_UP = BannerPatterns.define("gradient_up");
    public static final BannerPattern CIRCLE = BannerPatterns.define("circle");
    public static final BannerPattern STRIPE_DOWNLEFT = BannerPatterns.define("stripe_downleft");
    public static final BannerPattern RHOMBUS = BannerPatterns.define("rhombus");
    public static final BannerPattern TRIANGLES_BOTTOM = BannerPatterns.define("triangles_bottom");
    public static final BannerPattern STRIPE_CENTER = BannerPatterns.define("stripe_center");
    public static final BannerPattern SQUARE_BOTTOM_RIGHT = BannerPatterns.define("square_bottom_right");
    public static final BannerPattern DIAGONAL_RIGHT = BannerPatterns.define("diagonal_right");
    public static final BannerPattern MOJANG = BannerPatterns.define("mojang");
    public static final BannerPattern STRIPE_LEFT = BannerPatterns.define("stripe_left");
    public static final BannerPattern SQUARE_TOP_LEFT = BannerPatterns.define("square_top_left");
    public static final BannerPattern TRIANGLE_BOTTOM = BannerPatterns.define("triangle_bottom");
    public static final BannerPattern SKULL = BannerPatterns.define("skull");
    public static final BannerPattern SQUARE_TOP_RIGHT = BannerPatterns.define("square_top_right");
    public static final BannerPattern GLOBE = BannerPatterns.define("globe");
    public static final BannerPattern STRIPE_TOP = BannerPatterns.define("stripe_top");
    public static final BannerPattern CROSS = BannerPatterns.define("cross");
    public static final BannerPattern BRICKS = BannerPatterns.define("bricks");
    public static final BannerPattern HALF_VERTICAL = BannerPatterns.define("half_vertical");
    public static final BannerPattern STRIPE_DOWNRIGHT = BannerPatterns.define("stripe_downright");
    public static final BannerPattern TRIANGLES_TOP = BannerPatterns.define("triangles_top");
    public static final BannerPattern STRIPE_RIGHT = BannerPatterns.define("stripe_right");
    public static final BannerPattern DIAGONAL_UP_LEFT = BannerPatterns.define("diagonal_up_left");
    public static final BannerPattern HALF_VERTICAL_RIGHT = BannerPatterns.define("half_vertical_right");
    public static final BannerPattern TRIANGLE_TOP = BannerPatterns.define("triangle_top");
    public static final BannerPattern FLOWER = BannerPatterns.define("flower");
    public static final BannerPattern STRAIGHT_CROSS = BannerPatterns.define("straight_cross");
    public static final BannerPattern GRADIENT = BannerPatterns.define("gradient");
    public static final BannerPattern CURLY_BORDER = BannerPatterns.define("curly_border");
    public static final BannerPattern BORDER = BannerPatterns.define("border");
    public static final BannerPattern PIGLIN = BannerPatterns.define("piglin");
    public static final BannerPattern DIAGONAL_LEFT = BannerPatterns.define("diagonal_left");
    public static final BannerPattern FLOW = BannerPatterns.define("flow");
    public static final BannerPattern GUSTER = BannerPatterns.define("guster");

    public static BannerPattern define(String key) {
        ResourceLocation assetId = ResourceLocation.minecraft(key);
        String translationKey = "block.minecraft.banner." + key;
        return BannerPatterns.define(key, assetId, translationKey);
    }

    public static BannerPattern define(String key, final ResourceLocation assetId, final String translationKey) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        BannerPattern pattern = new BannerPattern(){

            @Override
            public ResourceLocation getAssetId() {
                return assetId;
            }

            @Override
            public String getTranslationKey() {
                return translationKey;
            }

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                return MappingHelper.getId(version, TYPES_BUILDER, data);
            }

            public boolean equals(Object obj) {
                if (obj instanceof BannerPattern) {
                    return this.getName().equals(((BannerPattern)obj).getName());
                }
                return false;
            }
        };
        MappingHelper.registerMapping(TYPES_BUILDER, PATTERN_TYPE_MAP, PATTERN_TYPE_ID_MAP, pattern);
        return pattern;
    }

    public static BannerPattern getByName(String name) {
        return PATTERN_TYPE_MAP.get(name);
    }

    public static BannerPattern getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, BannerPattern> idMap = PATTERN_TYPE_ID_MAP.get((byte)index);
        return idMap.get(id);
    }

    public static Collection<BannerPattern> values() {
        return Collections.unmodifiableCollection(PATTERN_TYPE_MAP.values());
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }
}

