/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.jukebox.JukeboxSong;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class ItemJukeboxPlayable {
    @Nullable
    private JukeboxSong song;
    @Nullable
    private ResourceLocation songKey;
    private boolean showInTooltip;

    public ItemJukeboxPlayable(@Nullable JukeboxSong song, @Nullable ResourceLocation songKey, boolean showInTooltip) {
        if (song == null == (songKey == null)) {
            throw new IllegalStateException("Illegal state of both song and song key combined: " + song + " / " + songKey);
        }
        this.song = song;
        this.songKey = songKey;
        this.showInTooltip = showInTooltip;
    }

    public static ItemJukeboxPlayable read(PacketWrapper<?> wrapper) {
        ResourceLocation songKey;
        JukeboxSong song;
        if (wrapper.readBoolean()) {
            song = JukeboxSong.read(wrapper);
            songKey = null;
        } else {
            song = null;
            songKey = wrapper.readIdentifier();
        }
        boolean showInTooltip = wrapper.readBoolean();
        return new ItemJukeboxPlayable(song, songKey, showInTooltip);
    }

    public static void write(PacketWrapper<?> wrapper, ItemJukeboxPlayable jukeboxPlayable) {
        if (jukeboxPlayable.song != null) {
            wrapper.writeBoolean(true);
            JukeboxSong.write(wrapper, jukeboxPlayable.song);
        } else {
            assert (jukeboxPlayable.songKey != null);
            wrapper.writeBoolean(false);
            wrapper.writeIdentifier(jukeboxPlayable.songKey);
        }
        wrapper.writeBoolean(jukeboxPlayable.showInTooltip);
    }

    @Nullable
    public JukeboxSong getSong() {
        return this.song;
    }

    public void setSong(JukeboxSong song) {
        this.song = song;
        this.songKey = null;
    }

    @Nullable
    public ResourceLocation getSongKey() {
        return this.songKey;
    }

    public void setSongKey(ResourceLocation songKey) {
        this.song = null;
        this.songKey = songKey;
    }

    public boolean isShowInTooltip() {
        return this.showInTooltip;
    }

    public void setShowInTooltip(boolean showInTooltip) {
        this.showInTooltip = showInTooltip;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemJukeboxPlayable)) {
            return false;
        }
        ItemJukeboxPlayable that = (ItemJukeboxPlayable)obj;
        if (this.showInTooltip != that.showInTooltip) {
            return false;
        }
        if (!Objects.equals(this.song, that.song)) {
            return false;
        }
        return Objects.equals(this.songKey, that.songKey);
    }

    public int hashCode() {
        return Objects.hash(this.song, this.songKey, this.showInTooltip);
    }
}

