/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.attribute.Attribute;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.attribute.AttributeOperation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.attribute.Attributes;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class ItemAttributeModifiers {
    public static final ItemAttributeModifiers EMPTY = new ItemAttributeModifiers(Collections.emptyList(), true){

        @Override
        public void setShowInTooltip(boolean showInTooltip) {
            throw new UnsupportedOperationException();
        }
    };
    private List<ModifierEntry> modifiers;
    private boolean showInTooltip;

    public ItemAttributeModifiers(List<ModifierEntry> modifiers, boolean showInTooltip) {
        this.modifiers = modifiers;
        this.showInTooltip = showInTooltip;
    }

    public static ItemAttributeModifiers read(PacketWrapper<?> wrapper) {
        List<ModifierEntry> modifiers = wrapper.readList(ModifierEntry::read);
        boolean showInTooltip = wrapper.readBoolean();
        return new ItemAttributeModifiers(modifiers, showInTooltip);
    }

    public static void write(PacketWrapper<?> wrapper, ItemAttributeModifiers modifiers) {
        wrapper.writeList(modifiers.modifiers, ModifierEntry::write);
        wrapper.writeBoolean(modifiers.showInTooltip);
    }

    public void addModifier(ModifierEntry modifier) {
        this.modifiers.add(modifier);
    }

    public List<ModifierEntry> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(List<ModifierEntry> modifiers) {
        this.modifiers = modifiers;
    }

    public boolean isShowInTooltip() {
        return this.showInTooltip;
    }

    public void setShowInTooltip(boolean showInTooltip) {
        this.showInTooltip = showInTooltip;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemAttributeModifiers)) {
            return false;
        }
        ItemAttributeModifiers that = (ItemAttributeModifiers)obj;
        if (this.showInTooltip != that.showInTooltip) {
            return false;
        }
        return this.modifiers.equals(that.modifiers);
    }

    public int hashCode() {
        return Objects.hash(this.modifiers, this.showInTooltip);
    }

    public String toString() {
        return "ItemAttributeModifiers{modifiers=" + this.modifiers + ", showInTooltip=" + this.showInTooltip + '}';
    }

    public static enum EquipmentSlotGroup {
        ANY,
        MAINHAND,
        OFFHAND,
        HAND,
        FEET,
        LEGS,
        CHEST,
        HEAD,
        ARMOR,
        BODY;

    }

    public static class Modifier {
        private UUID id;
        private String name;
        private double value;
        private AttributeOperation operation;

        public Modifier(UUID id, String name, double value, AttributeOperation operation) {
            this.id = id;
            this.name = name;
            this.value = value;
            this.operation = operation;
        }

        public static Modifier read(PacketWrapper<?> wrapper) {
            UUID id = wrapper.readUUID();
            String name = wrapper.readString();
            double value = wrapper.readDouble();
            AttributeOperation operation = (AttributeOperation)wrapper.readEnum(AttributeOperation.values());
            return new Modifier(id, name, value, operation);
        }

        public static void write(PacketWrapper<?> wrapper, Modifier modifier) {
            wrapper.writeUUID(modifier.id);
            wrapper.writeString(modifier.name);
            wrapper.writeDouble(modifier.value);
            wrapper.writeEnum(modifier.operation);
        }

        public UUID getId() {
            return this.id;
        }

        public void setId(UUID id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public AttributeOperation getOperation() {
            return this.operation;
        }

        public void setOperation(AttributeOperation operation) {
            this.operation = operation;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Modifier)) {
                return false;
            }
            Modifier modifier = (Modifier)obj;
            if (Double.compare(modifier.value, this.value) != 0) {
                return false;
            }
            if (!this.id.equals(modifier.id)) {
                return false;
            }
            if (!this.name.equals(modifier.name)) {
                return false;
            }
            return this.operation == modifier.operation;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.name, this.value, this.operation});
        }

        public String toString() {
            return "Modifier{id=" + this.id + ", name='" + this.name + '\'' + ", value=" + this.value + ", operation=" + (Object)((Object)this.operation) + '}';
        }
    }

    public static class ModifierEntry {
        private Attribute attribute;
        private Modifier modifier;
        private EquipmentSlotGroup slotGroup;

        public ModifierEntry(Attribute attribute, Modifier modifier, EquipmentSlotGroup slotGroup) {
            this.attribute = attribute;
            this.modifier = modifier;
            this.slotGroup = slotGroup;
        }

        public static ModifierEntry read(PacketWrapper<?> wrapper) {
            Attribute attribute = wrapper.readMappedEntity(Attributes::getById);
            Modifier modifier = Modifier.read(wrapper);
            EquipmentSlotGroup slot = (EquipmentSlotGroup)wrapper.readEnum(EquipmentSlotGroup.values());
            return new ModifierEntry(attribute, modifier, slot);
        }

        public static void write(PacketWrapper<?> wrapper, ModifierEntry entry) {
            wrapper.writeMappedEntity(entry.attribute);
            Modifier.write(wrapper, entry.modifier);
            wrapper.writeEnum(entry.slotGroup);
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public void setAttribute(Attribute attribute) {
            this.attribute = attribute;
        }

        public Modifier getModifier() {
            return this.modifier;
        }

        public void setModifier(Modifier modifier) {
            this.modifier = modifier;
        }

        public EquipmentSlotGroup getSlotGroup() {
            return this.slotGroup;
        }

        public void setSlotGroup(EquipmentSlotGroup slotGroup) {
            this.slotGroup = slotGroup;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ModifierEntry)) {
                return false;
            }
            ModifierEntry that = (ModifierEntry)obj;
            if (!this.attribute.equals(that.attribute)) {
                return false;
            }
            if (!this.modifier.equals(that.modifier)) {
                return false;
            }
            return this.slotGroup == that.slotGroup;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.attribute, this.modifier, this.slotGroup});
        }

        public String toString() {
            return "ModifierEntry{attribute=" + this.attribute + ", modifier=" + this.modifier + ", slotGroup=" + (Object)((Object)this.slotGroup) + '}';
        }
    }
}

