/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.color.DyeColor;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.ComponentType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ArmorTrim;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.BannerLayers;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.BundleContents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ChargedProjectiles;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.CustomData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.DebugStickState;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.FireworkExplosion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.FoodProperties;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemAdventurePredicate;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemAttributeModifiers;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemBees;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemBlockStateProperties;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemContainerContents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemContainerLoot;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemDyeColor;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemEnchantments;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemFireworks;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemJukeboxPlayable;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemLock;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemLore;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemMapDecorations;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemMapPostProcessingState;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemPotionContents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemProfile;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemRarity;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemRecipes;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.ItemTool;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.LodestoneTracker;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.PotDecorations;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.SuspiciousStewEffects;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.WritableBookContent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.builtin.item.WrittenBookContent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.instrument.Instrument;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTCompound;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.Dummy;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.MappingHelper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilder;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilderData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class ComponentTypes {
    private static final Map<String, ComponentType<?>> COMPONENT_TYPE_MAP = new HashMap();
    private static final Map<Byte, Map<Integer, ComponentType<?>>> COMPONENT_TYPE_ID_MAP = new HashMap();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("item/item_component_mappings");
    public static final ComponentType<NBTCompound> CUSTOM_DATA = ComponentTypes.define("custom_data", CustomData::read, CustomData::write);
    public static final ComponentType<Integer> MAX_STACK_SIZE = ComponentTypes.define("max_stack_size", PacketWrapper::readVarInt, PacketWrapper::writeVarInt);
    public static final ComponentType<Integer> MAX_DAMAGE = ComponentTypes.define("max_damage", PacketWrapper::readVarInt, PacketWrapper::writeVarInt);
    public static final ComponentType<Integer> DAMAGE = ComponentTypes.define("damage", PacketWrapper::readVarInt, PacketWrapper::writeVarInt);
    public static final ComponentType<Boolean> UNBREAKABLE = ComponentTypes.define("unbreakable", PacketWrapper::readBoolean, PacketWrapper::writeBoolean);
    public static final ComponentType<Component> CUSTOM_NAME = ComponentTypes.define("custom_name", PacketWrapper::readComponent, PacketWrapper::writeComponent);
    public static final ComponentType<Component> ITEM_NAME = ComponentTypes.define("item_name", PacketWrapper::readComponent, PacketWrapper::writeComponent);
    public static final ComponentType<ItemLore> LORE = ComponentTypes.define("lore", ItemLore::read, ItemLore::write);
    public static final ComponentType<ItemRarity> RARITY = ComponentTypes.define("rarity", wrapper -> (ItemRarity)wrapper.readEnum(ItemRarity.values()), PacketWrapper::writeEnum);
    public static final ComponentType<ItemEnchantments> ENCHANTMENTS = ComponentTypes.define("enchantments", ItemEnchantments::read, ItemEnchantments::write);
    public static final ComponentType<ItemAdventurePredicate> CAN_PLACE_ON = ComponentTypes.define("can_place_on", ItemAdventurePredicate::read, ItemAdventurePredicate::write);
    public static final ComponentType<ItemAdventurePredicate> CAN_BREAK = ComponentTypes.define("can_break", ItemAdventurePredicate::read, ItemAdventurePredicate::write);
    public static final ComponentType<ItemAttributeModifiers> ATTRIBUTE_MODIFIERS = ComponentTypes.define("attribute_modifiers", ItemAttributeModifiers::read, ItemAttributeModifiers::write);
    public static final ComponentType<Integer> CUSTOM_MODEL_DATA = ComponentTypes.define("custom_model_data", PacketWrapper::readVarInt, PacketWrapper::writeVarInt);
    public static final ComponentType<Dummy> HIDE_ADDITIONAL_TOOLTIP = ComponentTypes.define("hide_additional_tooltip", Dummy::dummyRead, Dummy::dummyWrite);
    public static final ComponentType<Dummy> HIDE_TOOLTIP = ComponentTypes.define("hide_tooltip", Dummy::dummyRead, Dummy::dummyWrite);
    public static final ComponentType<Integer> REPAIR_COST = ComponentTypes.define("repair_cost", PacketWrapper::readVarInt, PacketWrapper::writeVarInt);
    public static final ComponentType<Dummy> CREATIVE_SLOT_LOCK = ComponentTypes.define("creative_slot_lock", Dummy::dummyRead, Dummy::dummyWrite);
    public static final ComponentType<Boolean> ENCHANTMENT_GLINT_OVERRIDE = ComponentTypes.define("enchantment_glint_override", PacketWrapper::readBoolean, PacketWrapper::writeBoolean);
    public static final ComponentType<Dummy> INTANGIBLE_PROJECTILE = ComponentTypes.define("intangible_projectile", Dummy::dummyReadNbt, Dummy::dummyWriteNbt);
    public static final ComponentType<FoodProperties> FOOD = ComponentTypes.define("food", FoodProperties::read, FoodProperties::write);
    public static final ComponentType<Dummy> FIRE_RESISTANT = ComponentTypes.define("fire_resistant", Dummy::dummyRead, Dummy::dummyWrite);
    public static final ComponentType<ItemTool> TOOL = ComponentTypes.define("tool", ItemTool::read, ItemTool::write);
    public static final ComponentType<ItemEnchantments> STORED_ENCHANTMENTS = ComponentTypes.define("stored_enchantments", ItemEnchantments::read, ItemEnchantments::write);
    public static final ComponentType<ItemDyeColor> DYED_COLOR = ComponentTypes.define("dyed_color", ItemDyeColor::read, ItemDyeColor::write);
    public static final ComponentType<Integer> MAP_COLOR = ComponentTypes.define("map_color", PacketWrapper::readInt, PacketWrapper::writeInt);
    public static final ComponentType<Integer> MAP_ID = ComponentTypes.define("map_id", PacketWrapper::readVarInt, PacketWrapper::writeVarInt);
    public static final ComponentType<ItemMapDecorations> MAP_DECORATIONS = ComponentTypes.define("map_decorations", ItemMapDecorations::read, ItemMapDecorations::write);
    public static final ComponentType<ItemMapPostProcessingState> MAP_POST_PROCESSING = ComponentTypes.define("map_post_processing", wrapper -> (ItemMapPostProcessingState)wrapper.readEnum(ItemMapPostProcessingState.values()), PacketWrapper::writeEnum);
    public static final ComponentType<ChargedProjectiles> CHARGED_PROJECTILES = ComponentTypes.define("charged_projectiles", ChargedProjectiles::read, ChargedProjectiles::write);
    public static final ComponentType<BundleContents> BUNDLE_CONTENTS = ComponentTypes.define("bundle_contents", BundleContents::read, BundleContents::write);
    public static final ComponentType<ItemPotionContents> POTION_CONTENTS = ComponentTypes.define("potion_contents", ItemPotionContents::read, ItemPotionContents::write);
    public static final ComponentType<SuspiciousStewEffects> SUSPICIOUS_STEW_EFFECTS = ComponentTypes.define("suspicious_stew_effects", SuspiciousStewEffects::read, SuspiciousStewEffects::write);
    public static final ComponentType<WritableBookContent> WRITABLE_BOOK_CONTENT = ComponentTypes.define("writable_book_content", WritableBookContent::read, WritableBookContent::write);
    public static final ComponentType<WrittenBookContent> WRITTEN_BOOK_CONTENT = ComponentTypes.define("written_book_content", WrittenBookContent::read, WrittenBookContent::write);
    public static final ComponentType<ArmorTrim> TRIM = ComponentTypes.define("trim", ArmorTrim::read, ArmorTrim::write);
    public static final ComponentType<DebugStickState> DEBUG_STICK_STATE = ComponentTypes.define("debug_stick_state", DebugStickState::read, DebugStickState::write);
    public static final ComponentType<NBTCompound> ENTITY_DATA = ComponentTypes.define("entity_data", PacketWrapper::readNBT, PacketWrapper::writeNBT);
    public static final ComponentType<NBTCompound> BUCKET_ENTITY_DATA = ComponentTypes.define("bucket_entity_data", PacketWrapper::readNBT, PacketWrapper::writeNBT);
    public static final ComponentType<NBTCompound> BLOCK_ENTITY_DATA = ComponentTypes.define("block_entity_data", PacketWrapper::readNBT, PacketWrapper::writeNBT);
    public static final ComponentType<Instrument> INSTRUMENT = ComponentTypes.define("instrument", Instrument::read, Instrument::write);
    public static final ComponentType<Integer> OMINOUS_BOTTLE_AMPLIFIER = ComponentTypes.define("ominous_bottle_amplifier", PacketWrapper::readVarInt, PacketWrapper::writeVarInt);
    public static final ComponentType<ItemRecipes> RECIPES = ComponentTypes.define("recipes", ItemRecipes::read, ItemRecipes::write);
    public static final ComponentType<LodestoneTracker> LODESTONE_TRACKER = ComponentTypes.define("lodestone_tracker", LodestoneTracker::read, LodestoneTracker::write);
    public static final ComponentType<FireworkExplosion> FIREWORK_EXPLOSION = ComponentTypes.define("firework_explosion", FireworkExplosion::read, FireworkExplosion::write);
    public static final ComponentType<ItemFireworks> FIREWORKS = ComponentTypes.define("fireworks", ItemFireworks::read, ItemFireworks::write);
    public static final ComponentType<ItemProfile> PROFILE = ComponentTypes.define("profile", ItemProfile::read, ItemProfile::write);
    public static final ComponentType<ResourceLocation> NOTE_BLOCK_SOUND = ComponentTypes.define("note_block_sound", PacketWrapper::readIdentifier, PacketWrapper::writeIdentifier);
    public static final ComponentType<BannerLayers> BANNER_PATTERNS = ComponentTypes.define("banner_patterns", BannerLayers::read, BannerLayers::write);
    public static final ComponentType<DyeColor> BASE_COLOR = ComponentTypes.define("base_color", wrapper -> (DyeColor)wrapper.readEnum(DyeColor.values()), PacketWrapper::writeEnum);
    public static final ComponentType<PotDecorations> POT_DECORATIONS = ComponentTypes.define("pot_decorations", PotDecorations::read, PotDecorations::write);
    public static final ComponentType<ItemContainerContents> CONTAINER = ComponentTypes.define("container", ItemContainerContents::read, ItemContainerContents::write);
    public static final ComponentType<ItemBlockStateProperties> BLOCK_STATE = ComponentTypes.define("block_state", ItemBlockStateProperties::read, ItemBlockStateProperties::write);
    public static final ComponentType<ItemBees> BEES = ComponentTypes.define("bees", ItemBees::read, ItemBees::write);
    public static final ComponentType<ItemLock> LOCK = ComponentTypes.define("lock", ItemLock::read, ItemLock::write);
    public static final ComponentType<ItemContainerLoot> CONTAINER_LOOT = ComponentTypes.define("container_loot", ItemContainerLoot::read, ItemContainerLoot::write);
    public static final ComponentType<ItemJukeboxPlayable> JUKEBOX_PLAYABLE = ComponentTypes.define("jukebox_playable", ItemJukeboxPlayable::read, ItemJukeboxPlayable::write);

    public static <T> ComponentType<T> define(String key) {
        return ComponentTypes.define(key, null, null);
    }

    public static <T> ComponentType<T> define(String key, final @Nullable Reader<T> reader, final @Nullable Writer<T> writer) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        ComponentType type = new ComponentType<T>(){

            @Override
            public T read(PacketWrapper<?> wrapper) {
                return reader == null ? null : (Object)reader.apply(wrapper);
            }

            @Override
            public void write(PacketWrapper<?> wrapper, T content) {
                if (writer != null) {
                    writer.accept(wrapper, content);
                }
            }

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                return MappingHelper.getId(version, TYPES_BUILDER, data);
            }

            public boolean equals(Object obj) {
                if (obj instanceof ComponentType) {
                    return this.getName().equals(((ComponentType)obj).getName());
                }
                return false;
            }

            public String toString() {
                return "Component[" + this.getName() + "]";
            }
        };
        MappingHelper.registerMapping(TYPES_BUILDER, COMPONENT_TYPE_MAP, COMPONENT_TYPE_ID_MAP, type);
        return type;
    }

    public static ComponentType<?> getByName(String name) {
        return COMPONENT_TYPE_MAP.get(name);
    }

    public static ComponentType<?> getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, ComponentType<?>> idMap = COMPONENT_TYPE_ID_MAP.get((byte)index);
        return idMap.get(id);
    }

    public static Collection<ComponentType<?>> values() {
        return Collections.unmodifiableCollection(COMPONENT_TYPE_MAP.values());
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }

    @FunctionalInterface
    public static interface Reader<T>
    extends Function<PacketWrapper<?>, T> {
    }

    @FunctionalInterface
    public static interface Writer<T>
    extends BiConsumer<PacketWrapper<?>, T> {
    }
}

