/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.ComponentType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.ComponentValue;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.IComponentMap;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.PatchableComponentMap;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.component.StaticComponentMap;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public class ComponentPredicate
implements Predicate<IComponentMap> {
    private List<ComponentValue<?>> requiredComponents;

    public ComponentPredicate(List<ComponentValue<?>> requiredComponents) {
        this.requiredComponents = requiredComponents;
    }

    public static ComponentPredicate read(PacketWrapper<?> wrapper) {
        List<ComponentValue<?>> components = wrapper.readList(ComponentValue::read);
        return new ComponentPredicate(components);
    }

    public static void write(PacketWrapper<?> wrapper, ComponentPredicate predicate) {
        wrapper.writeList(predicate.requiredComponents, ComponentValue::write);
    }

    public static ComponentPredicate emptyPredicate() {
        return new ComponentPredicate(new ArrayList());
    }

    public static ComponentPredicate fromPatches(PatchableComponentMap components) {
        Map<ComponentType<?>, Optional<?>> patches = components.getPatches();
        ArrayList values = new ArrayList(patches.size());
        for (Map.Entry<ComponentType<?>, Optional<?>> patch : patches.entrySet()) {
            if (!patch.getValue().isPresent()) continue;
            values.add(new ComponentValue(patch.getKey(), patch.getValue().get()));
        }
        return new ComponentPredicate(values);
    }

    public PatchableComponentMap asPatches(StaticComponentMap base) {
        PatchableComponentMap patched = new PatchableComponentMap(base);
        for (ComponentValue<?> component : this.requiredComponents) {
            patched.set(component);
        }
        return patched;
    }

    @Override
    public boolean test(IComponentMap components) {
        for (ComponentValue<?> component : this.requiredComponents) {
            Optional<?> value = components.getOptional(component.getType());
            if (value.isPresent() && component.getValue().equals(value.get())) continue;
            return false;
        }
        return true;
    }

    public List<ComponentValue<?>> getRequiredComponents() {
        return this.requiredComponents;
    }

    public void setRequiredComponents(List<ComponentValue<?>> requiredComponents) {
        this.requiredComponents = requiredComponents;
    }
}

