/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.chat;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.chat.ChatType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.chat.ChatTypeDecoration;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.MappingHelper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilder;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.mappings.TypesBuilderData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ChatTypes {
    private static final Map<String, ChatType> CHAT_TYPE_MAP = new HashMap<String, ChatType>();
    private static final Map<Byte, Map<Integer, ChatType>> CHAT_TYPE_ID_MAP = new HashMap<Byte, Map<Integer, ChatType>>();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("chat/chat_type_mappings");
    public static final ChatType CHAT = ChatTypes.define("chat");
    public static final ChatType SAY_COMMAND = ChatTypes.define("say_command", ChatTypeDecoration.withSender("chat.type.announcement"));
    public static final ChatType MSG_COMMAND_INCOMING = ChatTypes.define("msg_command_incoming", ChatTypeDecoration.incomingDirectMessage("commands.message.display.incoming"));
    public static final ChatType MSG_COMMAND_OUTGOING = ChatTypes.define("msg_command_outgoing", ChatTypeDecoration.outgoingDirectMessage("commands.message.display.outgoing"));
    public static final ChatType TEAM_MSG_COMMAND_INCOMING = ChatTypes.define("team_msg_command_incoming", ChatTypeDecoration.teamMessage("chat.type.team.text"));
    public static final ChatType TEAM_MSG_COMMAND_OUTGOING = ChatTypes.define("team_msg_command_outgoing", ChatTypeDecoration.teamMessage("chat.type.team.sent"));
    public static final ChatType EMOTE_COMMAND = ChatTypes.define("emote_command", ChatTypeDecoration.withSender("chat.type.emote"), ChatTypeDecoration.withSender("chat.type.emote"));
    public static final ChatType RAW = ChatTypes.define("raw");
    @Deprecated
    public static final ChatType SYSTEM = ChatTypes.define("system");
    @Deprecated
    public static final ChatType GAME_INFO = ChatTypes.define("game_info");
    @Deprecated
    public static final ChatType MSG_COMMAND = ChatTypes.define("msg_command");
    @Deprecated
    public static final ChatType TEAM_MSG_COMMAND = ChatTypes.define("team_msg_command");

    public static ChatType define(String key) {
        return ChatTypes.define(key, ChatTypeDecoration.withSender("chat.type.text"));
    }

    public static ChatType define(String key, ChatTypeDecoration chatDeco) {
        return ChatTypes.define(key, chatDeco, ChatTypeDecoration.withSender("chat.type.text.narrate"));
    }

    public static ChatType define(String key, final ChatTypeDecoration chatDeco, final ChatTypeDecoration narrationDeco) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        ChatType chatType = new ChatType(){

            @Override
            public ChatTypeDecoration getChatDecoration() {
                return chatDeco;
            }

            @Override
            public ChatTypeDecoration getNarrationDecoration() {
                return narrationDeco;
            }

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                return MappingHelper.getId(version, TYPES_BUILDER, data);
            }
        };
        MappingHelper.registerMapping(TYPES_BUILDER, CHAT_TYPE_MAP, CHAT_TYPE_ID_MAP, chatType);
        return chatType;
    }

    public static ChatType getByName(String name) {
        return CHAT_TYPE_MAP.get(name);
    }

    public static ChatType getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        return CHAT_TYPE_ID_MAP.get((byte)index).get(id);
    }

    public static Collection<ChatType> values() {
        return Collections.unmodifiableCollection(CHAT_TYPE_MAP.values());
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }
}

