/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.chat;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.chat.ChatType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTCompound;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTList;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTString;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.adventure.AdventureSerializer;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.Component;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.ComponentLike;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.format.NamedTextColor;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.format.Style;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.format.TextColor;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.format.TextDecoration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nullable;

public class ChatTypeDecoration {
    private final String translationKey;
    private final List<Parameter> parameters;
    private final Style style;

    public ChatTypeDecoration(String translationKey, List<Parameter> parameters, Style style) {
        this.translationKey = translationKey;
        this.parameters = Collections.unmodifiableList(new ArrayList<Parameter>(parameters));
        this.style = style;
    }

    public ChatTypeDecoration(NBTCompound nbt) {
        this.translationKey = nbt.getStringTagValueOrDefault("translation_key", null);
        ArrayList<Parameter> temporaryList = new ArrayList<Parameter>();
        NBTList<NBTString> parametersTag = nbt.getStringListTagOrNull("parameters");
        if (parametersTag != null) {
            for (NBTString p : parametersTag.getTags()) {
                Parameter parameter = Parameter.valueByName(p.getValue().toUpperCase());
                if (parameter == null) continue;
                temporaryList.add(parameter);
            }
        }
        this.parameters = Collections.unmodifiableList(temporaryList);
        NBTCompound styleTag = nbt.getCompoundTagOrNull("style");
        this.style = styleTag != null ? AdventureSerializer.getNBTSerializer().deserializeStyle(styleTag) : Style.empty();
    }

    public static ChatTypeDecoration read(PacketWrapper<?> wrapper) {
        String translationKey = wrapper.readString();
        List<Parameter> parameters = wrapper.readList(ew -> (Parameter)ew.readEnum(Parameter.values()));
        Style style = wrapper.readStyle();
        return new ChatTypeDecoration(translationKey, parameters, style);
    }

    public static void write(PacketWrapper<?> wrapper, ChatTypeDecoration decoration) {
        wrapper.writeString(decoration.translationKey);
        wrapper.writeList(decoration.parameters, PacketWrapper::writeEnum);
        wrapper.writeStyle(decoration.style);
    }

    public static ChatTypeDecoration withSender(String translationKey) {
        return new ChatTypeDecoration(translationKey, Arrays.asList(Parameter.SENDER, Parameter.CONTENT), Style.empty());
    }

    public static ChatTypeDecoration incomingDirectMessage(String translationKey) {
        return new ChatTypeDecoration(translationKey, Arrays.asList(Parameter.SENDER, Parameter.CONTENT), Style.style((TextColor)NamedTextColor.GRAY, TextDecoration.ITALIC));
    }

    public static ChatTypeDecoration outgoingDirectMessage(String translationKey) {
        return new ChatTypeDecoration(translationKey, Arrays.asList(Parameter.TARGET, Parameter.CONTENT), Style.style((TextColor)NamedTextColor.GRAY, TextDecoration.ITALIC));
    }

    public static ChatTypeDecoration teamMessage(String translationKey) {
        return new ChatTypeDecoration(translationKey, Arrays.asList(Parameter.TARGET, Parameter.SENDER, Parameter.CONTENT), Style.empty());
    }

    public Component decorate(Component component, ChatType.Bound chatType) {
        ComponentLike[] components = new ComponentLike[this.parameters.size()];
        for (int i = 0; i < components.length; ++i) {
            Parameter parameter = this.parameters.get(i);
            components[i] = (ComponentLike)parameter.selector.apply(component, chatType);
        }
        return Component.translatable(this.translationKey, null, this.style, components);
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Style getStyle() {
        return this.style;
    }

    public static enum Parameter {
        SENDER((component, type) -> type.getName()),
        TARGET((component, type) -> type.getTargetName() != null ? type.getTargetName() : Component.empty()),
        CONTENT((component, type) -> component);

        private final BiFunction<Component, ChatType.Bound, Component> selector;

        private Parameter(BiFunction<Component, ChatType.Bound, Component> selector) {
            this.selector = selector;
        }

        @Nullable
        public static Parameter valueByName(String name) {
            try {
                return Parameter.valueOf(name);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
    }
}

