/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEvents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.type.EntityType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.type.EntityTypes;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.ItemStack;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.type.ItemType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTCompound;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.type.ParticleType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.GameMode;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.potion.PotionType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.potion.PotionTypes;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.Dimension;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.Location;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.WrappedBlockState;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util.SpigotReflectionUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.material.MaterialData;
import org.bukkit.potion.PotionEffectType;

public class SpigotConversionUtil {
    public static Location fromBukkitLocation(org.bukkit.Location location) {
        return new Location(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static org.bukkit.Location toBukkitLocation(World world, Location location) {
        return new org.bukkit.Location(world, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static PotionType fromBukkitPotionEffectType(PotionEffectType potionEffectType) {
        return PotionTypes.getById(potionEffectType.getId(), PacketEvents.getAPI().getServerManager().getVersion());
    }

    public static PotionEffectType toBukkitPotionEffectType(PotionType potionType) {
        return PotionEffectType.getById((int)potionType.getId(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()));
    }

    public static GameMode fromBukkitGameMode(org.bukkit.GameMode gameMode) {
        return GameMode.getById(gameMode.getValue());
    }

    public static org.bukkit.GameMode toBukkitGameMode(GameMode gameMode) {
        return org.bukkit.GameMode.getByValue((int)gameMode.getId());
    }

    public static WrappedBlockState fromBukkitBlockData(BlockData blockData) {
        String string = blockData.getAsString(false);
        return WrappedBlockState.getByString(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), string);
    }

    public static BlockData toBukkitBlockData(WrappedBlockState blockState) {
        return Bukkit.createBlockData((String)blockState.toString());
    }

    public static EntityType fromBukkitEntityType(org.bukkit.entity.EntityType entityType) {
        ServerVersion serverVersion = PacketEvents.getAPI().getServerManager().getVersion();
        if (serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            return EntityTypes.getByName(entityType.getKey().toString());
        }
        if (serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            return EntityTypes.getByName("minecraft:" + entityType.getName());
        }
        if (entityType.getTypeId() == -1) {
            return null;
        }
        return EntityTypes.getById(serverVersion.toClientVersion(), entityType.getTypeId());
    }

    public static org.bukkit.entity.EntityType toBukkitEntityType(EntityType entityType) {
        ServerVersion serverVersion = PacketEvents.getAPI().getServerManager().getVersion();
        if (serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            return org.bukkit.entity.EntityType.fromName((String)entityType.getName().getKey());
        }
        return org.bukkit.entity.EntityType.fromId((int)entityType.getId(serverVersion.toClientVersion()));
    }

    public static ItemType fromBukkitItemMaterial(Material material) {
        org.bukkit.inventory.ItemStack bukkitStack = new org.bukkit.inventory.ItemStack(material);
        ItemStack stack = SpigotConversionUtil.fromBukkitItemStack(bukkitStack);
        return stack.getType();
    }

    public static Material toBukkitItemMaterial(ItemType itemType) {
        ItemStack stack = ItemStack.builder().type(itemType).build();
        org.bukkit.inventory.ItemStack bukkitStack = SpigotConversionUtil.toBukkitItemStack(stack);
        return bukkitStack.getType();
    }

    public static WrappedBlockState fromBukkitMaterialData(MaterialData materialData) {
        int combinedID = SpigotReflectionUtil.getBlockDataCombinedId(materialData);
        ServerVersion serverVersion = PacketEvents.getAPI().getServerManager().getVersion();
        return WrappedBlockState.getByGlobalId(serverVersion.toClientVersion(), combinedID);
    }

    public static MaterialData toBukkitMaterialData(WrappedBlockState state) {
        return SpigotReflectionUtil.getBlockDataByCombinedId(state.getGlobalId());
    }

    public static ItemStack fromBukkitItemStack(org.bukkit.inventory.ItemStack itemStack) {
        return SpigotReflectionUtil.decodeBukkitItemStack(itemStack);
    }

    public static org.bukkit.inventory.ItemStack toBukkitItemStack(ItemStack itemStack) {
        return SpigotReflectionUtil.encodeBukkitItemStack(itemStack);
    }

    public static Dimension fromBukkitWorld(World world) {
        if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_14)) {
            return new Dimension(world.getEnvironment().getId());
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_16)) {
            Object worldServer = SpigotReflectionUtil.convertBukkitWorldToWorldServer(world);
            return new Dimension(SpigotReflectionUtil.getDimensionId(worldServer));
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_16_2)) {
            Object worldServer = SpigotReflectionUtil.convertBukkitWorldToWorldServer(world);
            Dimension dimension = new Dimension(new NBTCompound());
            dimension.setDimensionName(SpigotReflectionUtil.getDimensionKey(worldServer));
            return dimension;
        }
        Object worldServer = SpigotReflectionUtil.convertBukkitWorldToWorldServer(world);
        Object nbt = SpigotReflectionUtil.convertWorldServerDimensionToNMSNbt(worldServer);
        return new Dimension(SpigotReflectionUtil.fromMinecraftNBT(nbt));
    }

    public static ParticleType fromBukkitParticle(Enum<?> particle) {
        return SpigotReflectionUtil.toPacketEventsParticle(particle);
    }

    public static Enum<?> toBukkitParticle(ParticleType particle) {
        return SpigotReflectionUtil.fromPacketEventsParticle(particle);
    }
}

