/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.reflection.Reflection;
import java.lang.reflect.Method;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class FoliaCompatUtil {
    private static boolean folia;

    public static boolean isFolia() {
        return folia;
    }

    public static void runTaskAsync(Plugin plugin, Runnable run) {
        if (!folia) {
            Bukkit.getScheduler().runTaskAsynchronously(plugin, run);
            return;
        }
        Executors.defaultThreadFactory().newThread(run).start();
    }

    public static void runTaskTimerAsync(Plugin plugin, Consumer<Object> run, long delay, long period) {
        if (!folia) {
            Bukkit.getScheduler().runTaskTimerAsynchronously(plugin, () -> run.accept(null), delay, period);
            return;
        }
        try {
            Method getSchedulerMethod = Reflection.getMethod(Server.class, "getGlobalRegionScheduler", 0);
            Object globalRegionScheduler = getSchedulerMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
            Class<?> schedulerClass = globalRegionScheduler.getClass();
            Method executeMethod = schedulerClass.getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE);
            executeMethod.invoke(globalRegionScheduler, plugin, run, delay, period);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void runTask(Plugin plugin, Consumer<Object> run) {
        if (!folia) {
            Bukkit.getScheduler().runTask(plugin, () -> run.accept(null));
            return;
        }
        try {
            Method getSchedulerMethod = Reflection.getMethod(Server.class, "getGlobalRegionScheduler", 0);
            Object globalRegionScheduler = getSchedulerMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
            Class<?> schedulerClass = globalRegionScheduler.getClass();
            Method executeMethod = schedulerClass.getMethod("run", Plugin.class, Consumer.class);
            executeMethod.invoke(globalRegionScheduler, plugin, run);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void runTaskOnInit(Plugin plugin, Runnable run) {
        Class<?> serverInitEventClass;
        if (!folia) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(plugin, run);
            return;
        }
        try {
            serverInitEventClass = Class.forName("io.papermc.paper.threadedregions.RegionizedServerInitEvent");
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        Bukkit.getServer().getPluginManager().registerEvent(serverInitEventClass, new Listener(){}, EventPriority.HIGHEST, (listener, event) -> run.run(), plugin);
    }

    public static void runTaskForEntity(Entity entity, Plugin plugin, Runnable run, Runnable retired, long delay) {
        if (!folia) {
            Bukkit.getScheduler().runTaskLater(plugin, run, delay);
            return;
        }
        try {
            Method getSchedulerMethod = Reflection.getMethod(Entity.class, "getScheduler", 0);
            Object entityScheduler = getSchedulerMethod.invoke((Object)entity, new Object[0]);
            Class<?> schedulerClass = entityScheduler.getClass();
            Method executeMethod = schedulerClass.getMethod("execute", Plugin.class, Runnable.class, Runnable.class, Long.TYPE);
            executeMethod.invoke(entityScheduler, plugin, run, retired, delay);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            folia = true;
        }
        catch (ClassNotFoundException e) {
            folia = false;
        }
    }
}

