/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.io.packetevents.packetevents.manager.server;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEvents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerManager;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.PEVersion;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ServerManagerImpl
implements ServerManager {
    private ServerVersion serverVersion;

    private ServerVersion resolveVersionNoCache() {
        PEVersion latestVersion;
        Plugin plugin = (Plugin)PacketEvents.getAPI().getPlugin();
        String bukkitVersion = Bukkit.getBukkitVersion();
        ServerVersion fallbackVersion = ServerVersion.V_1_8_8;
        if (bukkitVersion.contains("Unknown")) {
            return fallbackVersion;
        }
        PEVersion version = new PEVersion(bukkitVersion.substring(0, bukkitVersion.indexOf("-")));
        if (version.isNewerThan(latestVersion = new PEVersion(ServerVersion.getLatest().getReleaseName()))) {
            plugin.getLogger().warning("[packetevents] We currently do not support the minecraft version " + version.toString() + ", so things might break. PacketEvents will behave as if the minecraft version were " + latestVersion.toString() + "!");
            return ServerVersion.getLatest();
        }
        for (ServerVersion val : ServerVersion.reversedValues()) {
            if (!bukkitVersion.contains(val.getReleaseName())) continue;
            return val;
        }
        plugin.getLogger().warning("[packetevents] Your server software is preventing us from checking the server version. This is what we found: " + Bukkit.getBukkitVersion() + ". We will assume the server version is " + fallbackVersion.name() + "...");
        return fallbackVersion;
    }

    @Override
    public ServerVersion getVersion() {
        if (this.serverVersion == null) {
            this.serverVersion = this.resolveVersionNoCache();
        }
        return this.serverVersion;
    }
}

