/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketSendEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class WrapperPlayServerUpdateAttributes
extends PacketWrapper<WrapperPlayServerUpdateAttributes> {
    private int entityID;
    private List<Property> properties;

    public WrapperPlayServerUpdateAttributes(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerUpdateAttributes(int entityID, List<Property> properties) {
        super(PacketType.Play.Server.UPDATE_ATTRIBUTES);
        this.entityID = entityID;
        this.properties = properties;
    }

    @Override
    public void read() {
        this.entityID = this.serverVersion == ServerVersion.V_1_7_10 ? this.readInt() : this.readVarInt();
        int propertyCount = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17) ? this.readVarInt() : this.readInt();
        this.properties = new ArrayList<Property>(propertyCount);
        for (int i = 0; i < propertyCount; ++i) {
            int maxKeyLength = Short.MAX_VALUE;
            String key = this.readString(maxKeyLength);
            double value = this.readDouble();
            int modifiersLength = this.serverVersion == ServerVersion.V_1_7_10 ? this.readShort() : this.readVarInt();
            ArrayList<PropertyModifier> modifiers = new ArrayList<PropertyModifier>(modifiersLength);
            for (int j = 0; j < modifiersLength; ++j) {
                UUID uuid = this.readUUID();
                double amount = this.readDouble();
                byte operationIndex = this.readByte();
                PropertyModifier.Operation operation = PropertyModifier.Operation.VALUES[operationIndex];
                modifiers.add(new PropertyModifier(uuid, amount, operation));
            }
            this.properties.add(new Property(key, value, modifiers));
        }
    }

    @Override
    public void write() {
        if (this.serverVersion == ServerVersion.V_1_7_10) {
            this.writeInt(this.entityID);
        } else {
            this.writeVarInt(this.entityID);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.writeVarInt(this.properties.size());
        } else {
            this.writeInt(this.properties.size());
        }
        for (Property property : this.properties) {
            int maxKeyLength = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16) ? Short.MAX_VALUE : 64;
            this.writeString(property.key, maxKeyLength);
            this.writeDouble(property.value);
            if (this.serverVersion == ServerVersion.V_1_7_10) {
                this.writeShort(property.modifiers.size());
            } else {
                this.writeVarInt(property.modifiers.size());
            }
            for (PropertyModifier modifier : property.modifiers) {
                this.writeUUID(modifier.uuid);
                this.writeDouble(modifier.amount);
                this.writeByte(modifier.operation.ordinal());
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerUpdateAttributes wrapper) {
        this.entityID = wrapper.entityID;
        this.properties = wrapper.properties;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public void setEntityId(int entityID) {
        this.entityID = entityID;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public static class Property {
        private String key;
        private double value;
        private List<PropertyModifier> modifiers;

        public Property(String key, double value, List<PropertyModifier> modifiers) {
            this.key = key;
            this.value = value;
            this.modifiers = modifiers;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public List<PropertyModifier> getModifiers() {
            return this.modifiers;
        }

        public void setModifiers(List<PropertyModifier> modifiers) {
            this.modifiers = modifiers;
        }
    }

    public static class PropertyModifier {
        private UUID uuid;
        private double amount;
        private Operation operation;

        public PropertyModifier(UUID uuid, double amount, Operation operation) {
            this.uuid = uuid;
            this.amount = amount;
            this.operation = operation;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public void setUUID(UUID uuid) {
            this.uuid = uuid;
        }

        public double getAmount() {
            return this.amount;
        }

        public void setAmount(double amount) {
            this.amount = amount;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public void setOperation(Operation operation) {
            this.operation = operation;
        }

        public static enum Operation {
            ADDITION,
            MULTIPLY_BASE,
            MULTIPLY_TOTAL;

            public static final Operation[] VALUES;

            static {
                VALUES = Operation.values();
            }
        }
    }
}

