/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketSendEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.Vector3i;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.util.Optional;

public class WrapperPlayServerSpawnPosition
extends PacketWrapper<WrapperPlayServerSpawnPosition> {
    private Vector3i position;
    private Float angle;

    public WrapperPlayServerSpawnPosition(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerSpawnPosition(Vector3i position) {
        super(PacketType.Play.Server.SPAWN_POSITION);
        this.position = position;
    }

    public WrapperPlayServerSpawnPosition(Vector3i position, float angle) {
        super(PacketType.Play.Server.SPAWN_POSITION);
        this.position = position;
        this.angle = Float.valueOf(angle);
    }

    @Override
    public void read() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            this.position = new Vector3i(this.readLong());
        } else {
            int x = this.readInt();
            short y = this.readShort();
            int z = this.readInt();
            this.position = new Vector3i(x, y, z);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.angle = Float.valueOf(this.readFloat());
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            long positionVector = this.position.getSerializedPosition();
            this.writeLong(positionVector);
        } else {
            this.writeInt(this.position.x);
            this.writeShort(this.position.y);
            this.writeInt(this.position.z);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.writeFloat(this.angle.floatValue());
        }
    }

    @Override
    public void copy(WrapperPlayServerSpawnPosition wrapper) {
        this.position = wrapper.position;
        this.angle = wrapper.angle;
    }

    public Vector3i getPosition() {
        return this.position;
    }

    public void setPosition(Vector3i position) {
        this.position = position;
    }

    public Optional<Float> getAngle() {
        return Optional.ofNullable(this.angle);
    }

    public void setAngle(float angle) {
        this.angle = Float.valueOf(angle);
    }
}

