/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketSendEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.sound.SoundCategory;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.Vector3i;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;

public class WrapperPlayServerSoundEffect
extends PacketWrapper<WrapperPlayServerSoundEffect> {
    private int soundID;
    private SoundCategory soundCategory;
    private Vector3i effectPosition;
    private float volume;
    private float pitch;
    private long seed;

    public WrapperPlayServerSoundEffect(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerSoundEffect(int soundID, SoundCategory soundCategory, Vector3i effectPosition, float volume, float pitch) {
        this(soundID, soundCategory, effectPosition, volume, pitch, -1L);
    }

    public WrapperPlayServerSoundEffect(int soundID, SoundCategory soundCategory, Vector3i effectPosition, float volume, float pitch, long seed) {
        super(PacketType.Play.Server.SOUND_EFFECT);
        this.soundID = soundID;
        this.soundCategory = soundCategory;
        this.effectPosition = effectPosition;
        this.volume = volume;
        this.pitch = pitch;
        this.seed = seed;
    }

    @Override
    public void read() {
        this.soundID = this.readVarInt();
        this.soundCategory = SoundCategory.fromId(this.readVarInt());
        this.effectPosition = new Vector3i(this.readInt(), this.readInt(), this.readInt());
        this.volume = this.readFloat();
        this.pitch = this.readFloat();
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.seed = this.readLong();
        }
    }

    @Override
    public void write() {
        this.writeVarInt(this.soundID);
        this.writeVarInt(this.soundCategory.ordinal());
        this.writeInt(this.effectPosition.x);
        this.writeInt(this.effectPosition.y);
        this.writeInt(this.effectPosition.z);
        this.writeFloat(this.volume);
        this.writeFloat(this.pitch);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.writeLong(this.seed);
        }
    }

    @Override
    public void copy(WrapperPlayServerSoundEffect wrapper) {
        this.soundID = wrapper.soundID;
        this.soundCategory = wrapper.soundCategory;
        this.effectPosition = wrapper.effectPosition;
        this.volume = wrapper.volume;
        this.pitch = wrapper.pitch;
        this.seed = wrapper.seed;
    }

    public int getSoundId() {
        return this.soundID;
    }

    public void setSoundId(int soundID) {
        this.soundID = soundID;
    }

    public SoundCategory getSoundCategory() {
        return this.soundCategory;
    }

    public void setSoundCategory(SoundCategory soundCategory) {
        this.soundCategory = soundCategory;
    }

    public Vector3i getEffectPosition() {
        return this.effectPosition;
    }

    public void setEffectPosition(Vector3i effectPosition) {
        this.effectPosition = effectPosition;
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }
}

