/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.configuration.server;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketSendEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class WrapperConfigServerResourcePackSend
extends PacketWrapper<WrapperConfigServerResourcePackSend> {
    public static final int MAX_HASH_LENGTH = 40;
    private String url;
    private String hash;
    private boolean required;
    private Component prompt;

    public WrapperConfigServerResourcePackSend(PacketSendEvent event) {
        super(event);
    }

    public WrapperConfigServerResourcePackSend(String url, String hash, boolean required, @Nullable Component prompt) {
        super(PacketType.Configuration.Server.RESOURCE_PACK_SEND);
        if (hash.length() > 40) {
            throw new IllegalArgumentException("Hash is too long (max 40, was " + hash.length() + ")");
        }
        this.url = url;
        this.hash = hash;
        this.required = required;
        this.prompt = prompt;
    }

    @Override
    public void read() {
        this.url = this.readString();
        this.hash = this.readString(40);
        this.required = this.readBoolean();
        if (this.readBoolean()) {
            this.prompt = this.readComponent();
        }
    }

    @Override
    public void write() {
        this.writeString(this.url);
        this.writeString(this.hash, 40);
        this.writeBoolean(this.required);
        if (this.prompt != null) {
            this.writeBoolean(true);
            this.writeComponent(this.prompt);
        } else {
            this.writeBoolean(false);
        }
    }

    @Override
    public void copy(WrapperConfigServerResourcePackSend wrapper) {
        this.url = wrapper.url;
        this.hash = wrapper.hash;
        this.required = wrapper.required;
        this.prompt = wrapper.prompt;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public Component getPrompt() {
        return this.prompt;
    }

    public void setPrompt(Component prompt) {
        this.prompt = prompt;
    }
}

