/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.adventure;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEvents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.adventure.GsonComponentSerializerExtended;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.adventure.serializer.gson.GsonComponentSerializer;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.adventure.serializer.legacy.LegacyComponentSerializer;
import com.google.gson.JsonElement;
import net.kyori.adventure.text.Component;

public class AdventureSerializer {
    private static GsonComponentSerializer GSON;
    private static LegacyComponentSerializer LEGACY;

    public static GsonComponentSerializer getGsonSerializer() {
        if (GSON == null) {
            ServerVersion version = PacketEvents.getAPI().getServerManager().getVersion();
            GSON = new GsonComponentSerializerExtended(version.isOlderThan(ServerVersion.V_1_16) && PacketEvents.getAPI().getSettings().shouldDownsampleColors(), version.isOlderThanOrEquals(ServerVersion.V_1_12_2));
        }
        return GSON;
    }

    public static LegacyComponentSerializer getLegacyGsonSerializer() {
        if (LEGACY == null) {
            LegacyComponentSerializer.Builder builder = LegacyComponentSerializer.builder();
            if (!PacketEvents.getAPI().getSettings().shouldDownsampleColors() || PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_16)) {
                builder = builder.hexColors();
            }
            LEGACY = builder.build();
        }
        return LEGACY;
    }

    public static String asVanilla(Component component) {
        return AdventureSerializer.getLegacyGsonSerializer().serialize(component);
    }

    public static Component fromLegacyFormat(String legacyMessage) {
        return AdventureSerializer.getLegacyGsonSerializer().deserialize(legacyMessage);
    }

    public static Component parseComponent(String json) {
        return AdventureSerializer.getGsonSerializer().deserialize(json);
    }

    public static Component parseJsonTree(JsonElement json) {
        return AdventureSerializer.getGsonSerializer().deserializeFromTree(json);
    }

    public static String toJson(Component component) {
        return (String)AdventureSerializer.getGsonSerializer().serialize(component);
    }

    public static JsonElement toJsonTree(Component component) {
        return AdventureSerializer.getGsonSerializer().serializeToTree(component);
    }
}

