/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.type;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEvents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.MaterialType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.WrappedBlockState;

public class StateType {
    private final String name;
    private final float blastResistance;
    private final float hardness;
    private final boolean isSolid;
    private final boolean isBlocking;
    private final boolean isAir;
    private final boolean requiresCorrectTool;
    private final boolean exceedsCube;
    private final MaterialType materialType;

    public StateType(String name, float blastResistance, float hardness, boolean isSolid, boolean isBlocking, boolean isAir, boolean requiresCorrectTool, boolean isShapeExceedsCube, MaterialType materialType) {
        this.name = name;
        this.blastResistance = blastResistance;
        this.hardness = hardness;
        this.isSolid = isSolid;
        this.isBlocking = isBlocking;
        this.isAir = isAir;
        this.requiresCorrectTool = requiresCorrectTool;
        this.exceedsCube = isShapeExceedsCube;
        this.materialType = materialType;
    }

    public WrappedBlockState createBlockState() {
        return WrappedBlockState.getDefaultState(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), this);
    }

    public WrappedBlockState createBlockState(ClientVersion version) {
        return WrappedBlockState.getDefaultState(version, this);
    }

    public String getName() {
        return this.name;
    }

    public float getBlastResistance() {
        return this.blastResistance;
    }

    public float getHardness() {
        return this.hardness;
    }

    public boolean isSolid() {
        return this.isSolid;
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    public boolean isAir() {
        return this.isAir;
    }

    public boolean isRequiresCorrectTool() {
        return this.requiresCorrectTool;
    }

    public boolean isReplaceable() {
        switch (this.getMaterialType()) {
            case AIR: 
            case STRUCTURAL_AIR: 
            case REPLACEABLE_PLANT: 
            case REPLACEABLE_FIREPROOF_PLANT: 
            case REPLACEABLE_WATER_PLANT: 
            case WATER: 
            case BUBBLE_COLUMN: 
            case LAVA: 
            case TOP_SNOW: 
            case FIRE: {
                return true;
            }
        }
        return false;
    }

    public boolean exceedsCube() {
        return this.exceedsCube;
    }

    public MaterialType getMaterialType() {
        return this.materialType;
    }

    public String toString() {
        return this.name;
    }
}

