/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEvents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.BlockFace;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.Attachment;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.Axis;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.Bloom;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.East;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.Face;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.Half;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.Hinge;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.Instrument;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.Leaves;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.Mode;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.North;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.Orientation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.Part;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.SculkSensorPhase;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.Shape;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.South;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.Thickness;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.Tilt;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.Type;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.VerticalDirection;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.enums.West;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.type.StateType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.type.StateTypes;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.type.StateValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class WrappedBlockState {
    private static final WrappedBlockState AIR = new WrappedBlockState(StateTypes.AIR, new EnumMap<StateValue, Object>(StateValue.class), 0, 0);
    private static final Map<Byte, Map<String, WrappedBlockState>> BY_STRING = new HashMap<Byte, Map<String, WrappedBlockState>>();
    private static final Map<Byte, Map<Integer, WrappedBlockState>> BY_ID = new HashMap<Byte, Map<Integer, WrappedBlockState>>();
    private static final Map<Byte, Map<WrappedBlockState, String>> INTO_STRING = new HashMap<Byte, Map<WrappedBlockState, String>>();
    private static final Map<Byte, Map<WrappedBlockState, Integer>> INTO_ID = new HashMap<Byte, Map<WrappedBlockState, Integer>>();
    private static final Map<Byte, Map<StateType, WrappedBlockState>> DEFAULT_STATES = new HashMap<Byte, Map<StateType, WrappedBlockState>>();
    private static final Map<String, String> STRING_UPDATER = new HashMap<String, String>();
    private static Map<Map<StateValue, Object>, Map<StateValue, Object>> cache = new HashMap<Map<StateValue, Object>, Map<StateValue, Object>>(4845, 70.0f);
    int globalID;
    StateType type;
    Map<StateValue, Object> data = new HashMap<StateValue, Object>(0);
    boolean hasClonedData = false;
    byte mappingsIndex;

    public WrappedBlockState(StateType type, String[] data, int globalID, byte mappingsIndex) {
        this.type = type;
        this.globalID = globalID;
        if (data != null) {
            for (String s : data) {
                try {
                    String[] split = s.split("=");
                    StateValue value = StateValue.byName(split[0]);
                    this.data.put(value, value.getParser().apply(split[1].toUpperCase(Locale.ROOT)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Failed to parse block state: " + s);
                }
            }
        }
        this.data = cache.computeIfAbsent(this.data, key -> key);
        this.mappingsIndex = mappingsIndex;
    }

    public WrappedBlockState(StateType type, Map<StateValue, Object> data, int globalID, byte mappingsIndex) {
        this.globalID = globalID;
        this.type = type;
        this.data = data;
        this.mappingsIndex = mappingsIndex;
    }

    @NotNull
    public static WrappedBlockState getByGlobalId(int globalID) {
        return WrappedBlockState.getByGlobalId(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), globalID);
    }

    @NotNull
    public static WrappedBlockState getByGlobalId(ClientVersion version, int globalID) {
        if (globalID == 0) {
            return AIR;
        }
        byte mappingsIndex = WrappedBlockState.getMappingsIndex(version);
        return BY_ID.get(mappingsIndex).getOrDefault(globalID, AIR).clone();
    }

    @NotNull
    public static WrappedBlockState getByString(String string) {
        return WrappedBlockState.getByString(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), string);
    }

    @NotNull
    public static WrappedBlockState getByString(ClientVersion version, String string) {
        byte mappingsIndex = WrappedBlockState.getMappingsIndex(version);
        return BY_STRING.get(mappingsIndex).getOrDefault(string.replace("minecraft:", ""), AIR).clone();
    }

    @NotNull
    public static WrappedBlockState getDefaultState(StateType type) {
        return WrappedBlockState.getDefaultState(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), type);
    }

    @NotNull
    public static WrappedBlockState getDefaultState(ClientVersion version, StateType type) {
        if (type == StateTypes.AIR) {
            return AIR;
        }
        byte mappingsIndex = WrappedBlockState.getMappingsIndex(version);
        WrappedBlockState state = DEFAULT_STATES.get(mappingsIndex).get(type);
        if (state == null) {
            PacketEvents.getAPI().getLogger().config("Default state for " + type.getName() + " is null. Returning AIR");
            return AIR;
        }
        return state.clone();
    }

    private static byte getMappingsIndex(ClientVersion version) {
        if (version.isOlderThan(ClientVersion.V_1_13)) {
            return 0;
        }
        if (version.isOlderThanOrEquals(ClientVersion.V_1_13_1)) {
            return 1;
        }
        if (version.isOlderThanOrEquals(ClientVersion.V_1_13_2)) {
            return 2;
        }
        if (version.isOlderThanOrEquals(ClientVersion.V_1_14_4)) {
            return 3;
        }
        if (version.isOlderThanOrEquals(ClientVersion.V_1_15_2)) {
            return 4;
        }
        if (version.isOlderThanOrEquals(ClientVersion.V_1_16_1)) {
            return 5;
        }
        if (version.isOlderThanOrEquals(ClientVersion.V_1_16_4)) {
            return 6;
        }
        if (version.isOlderThanOrEquals(ClientVersion.V_1_18_2)) {
            return 7;
        }
        if (version.isOlderThanOrEquals(ClientVersion.V_1_19_1)) {
            return 8;
        }
        if (version.isOlderThanOrEquals(ClientVersion.V_1_19_3)) {
            return 9;
        }
        if (version.isOlderThanOrEquals(ClientVersion.V_1_19_4)) {
            return 10;
        }
        if (version.isOlderThanOrEquals(ClientVersion.V_1_20)) {
            return 11;
        }
        return 12;
    }

    private static void loadLegacy() {
        HashMap<Integer, WrappedBlockState> stateByIdMap = new HashMap<Integer, WrappedBlockState>();
        HashMap<WrappedBlockState, Integer> stateToIdMap = new HashMap<WrappedBlockState, Integer>();
        HashMap<String, WrappedBlockState> stateByStringMap = new HashMap<String, WrappedBlockState>();
        HashMap<WrappedBlockState, String> stateToStringMap = new HashMap<WrappedBlockState, String>();
        HashMap<StateType, WrappedBlockState> stateTypeToBlockStateMap = new HashMap<StateType, WrappedBlockState>();
        try {
            String line;
            InputStream mappings = PacketEvents.getAPI().getSettings().getResourceProvider().apply("assets/mappings/block/legacy_block_mappings.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(mappings));
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(",");
                int id = Integer.parseInt(split[0]);
                int data = Integer.parseInt(split[1]);
                int combinedID = id << 4 | data;
                String fullString = line.substring(split[0].length() + split[1].length() + 2);
                int endIndex = split[2].indexOf("[");
                String blockString = split[2].substring(0, endIndex != -1 ? endIndex : split[2].length());
                StateType type = StateTypes.getByName(blockString);
                String[] dataStrings = null;
                if (endIndex != -1) {
                    dataStrings = line.substring(split[0].length() + split[1].length() + 2 + blockString.length() + 1, line.length() - 1).split(",");
                }
                if (type == null) {
                    PacketEvents.getAPI().getLogger().warning("Could not find type for " + blockString);
                }
                WrappedBlockState state = new WrappedBlockState(type, dataStrings, combinedID, 0);
                stateByIdMap.put(combinedID, state);
                stateToStringMap.put(state, fullString);
                stateToIdMap.put(state, combinedID);
                stateByStringMap.putIfAbsent(fullString, state);
                stateTypeToBlockStateMap.putIfAbsent(type, state);
            }
        }
        catch (IOException e) {
            PacketEvents.getAPI().getLogManager().debug("Palette reading failed! Unsupported version?");
            e.printStackTrace();
        }
        BY_ID.put((byte)0, stateByIdMap);
        INTO_ID.put((byte)0, stateToIdMap);
        BY_STRING.put((byte)0, stateByStringMap);
        INTO_STRING.put((byte)0, stateToStringMap);
        DEFAULT_STATES.put((byte)0, stateTypeToBlockStateMap);
    }

    private static void loadModern(ClientVersion version) {
        byte mappingsIndex = WrappedBlockState.getMappingsIndex(version);
        if (BY_ID.containsKey(mappingsIndex)) {
            return;
        }
        InputStream mappings = PacketEvents.getAPI().getSettings().getResourceProvider().apply("assets/mappings/block/modern_block_mappings.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(mappings));
        HashMap<Integer, WrappedBlockState> stateByIdMap = new HashMap<Integer, WrappedBlockState>();
        HashMap<WrappedBlockState, Integer> stateToIdMap = new HashMap<WrappedBlockState, Integer>();
        HashMap<String, WrappedBlockState> stateByStringMap = new HashMap<String, WrappedBlockState>();
        HashMap<WrappedBlockState, String> stateToStringMap = new HashMap<WrappedBlockState, String>();
        HashMap<StateType, WrappedBlockState> stateTypeToBlockStateMap = new HashMap<StateType, WrappedBlockState>();
        String versionString = version.getReleaseName();
        boolean found = false;
        int id = 0;
        try {
            String fullBlockString;
            while ((fullBlockString = reader.readLine()) != null) {
                if (!found) {
                    if (!fullBlockString.equals(versionString)) continue;
                    found = true;
                    continue;
                }
                if (fullBlockString.charAt(1) != '.') {
                    boolean isDefault = fullBlockString.startsWith("*");
                    int index = (fullBlockString = fullBlockString.replace("*", "")).indexOf("[");
                    String blockString = fullBlockString.substring(0, index == -1 ? fullBlockString.length() : index);
                    StateType type = StateTypes.getByName(blockString);
                    if (type == null) {
                        for (Map.Entry<String, String> stringEntry : STRING_UPDATER.entrySet()) {
                            blockString = blockString.replace(stringEntry.getKey(), stringEntry.getValue());
                        }
                        type = StateTypes.getByName(blockString);
                        if (type == null) {
                            PacketEvents.getAPI().getLogger().warning("Unknown block type: " + fullBlockString);
                        }
                    }
                    String[] data = null;
                    if (index != -1) {
                        data = fullBlockString.substring(index + 1, fullBlockString.length() - 1).split(",");
                    }
                    WrappedBlockState state = new WrappedBlockState(type, data, id, mappingsIndex);
                    if (isDefault) {
                        stateTypeToBlockStateMap.put(state.getType(), state);
                    }
                    stateByStringMap.put(fullBlockString, state);
                    stateByIdMap.put(id, state);
                    stateToStringMap.put(state, fullBlockString);
                    stateToIdMap.put(state, id);
                    ++id;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BY_ID.put(mappingsIndex, stateByIdMap);
        INTO_ID.put(mappingsIndex, stateToIdMap);
        BY_STRING.put(mappingsIndex, stateByStringMap);
        INTO_STRING.put(mappingsIndex, stateToStringMap);
        DEFAULT_STATES.put(mappingsIndex, stateTypeToBlockStateMap);
    }

    public WrappedBlockState clone() {
        return new WrappedBlockState(this.type, this.data, this.globalID, this.mappingsIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WrappedBlockState)) {
            return false;
        }
        WrappedBlockState that = (WrappedBlockState)o;
        return this.type == that.type && this.data.equals(that.data);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.data);
    }

    public StateType getType() {
        return this.type;
    }

    public int getAge() {
        return (Integer)this.data.get((Object)StateValue.AGE);
    }

    public void setAge(int age) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.AGE, age);
        this.checkIsStillValid();
    }

    public boolean isAttached() {
        return (Boolean)this.data.get((Object)StateValue.ATTACHED);
    }

    public void setAttached(boolean attached) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.ATTACHED, attached);
        this.checkIsStillValid();
    }

    public Attachment getAttachment() {
        return (Attachment)((Object)this.data.get((Object)StateValue.ATTACHMENT));
    }

    public void setAttachment(Attachment attachment) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.ATTACHMENT, (Object)attachment);
        this.checkIsStillValid();
    }

    public Axis getAxis() {
        return (Axis)((Object)this.data.get((Object)StateValue.AXIS));
    }

    public void setAxis(Axis axis) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.AXIS, (Object)axis);
        this.checkIsStillValid();
    }

    public boolean isBerries() {
        return (Boolean)this.data.get((Object)StateValue.BERRIES);
    }

    public void setBerries(boolean berries) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.BERRIES, berries);
        this.checkIsStillValid();
    }

    public int getBites() {
        return (Integer)this.data.get((Object)StateValue.BITES);
    }

    public void setBites(int bites) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.BITES, bites);
        this.checkIsStillValid();
    }

    public boolean isBottom() {
        return (Boolean)this.data.get((Object)StateValue.BOTTOM);
    }

    public void setBottom(boolean bottom) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.BOTTOM, bottom);
        this.checkIsStillValid();
    }

    public int getCandles() {
        return (Integer)this.data.get((Object)StateValue.CANDLES);
    }

    public void setCandles(int candles) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.CANDLES, candles);
        this.checkIsStillValid();
    }

    public int getCharges() {
        return (Integer)this.data.get((Object)StateValue.CHARGES);
    }

    public void setCharges(int charges) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.CHARGES, charges);
        this.checkIsStillValid();
    }

    public boolean isConditional() {
        return (Boolean)this.data.get((Object)StateValue.CONDITIONAL);
    }

    public void setConditional(boolean conditional) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.CONDITIONAL, conditional);
        this.checkIsStillValid();
    }

    public int getDelay() {
        return (Integer)this.data.get((Object)StateValue.DELAY);
    }

    public void setDelay(int delay) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.DELAY, delay);
        this.checkIsStillValid();
    }

    public boolean isDisarmed() {
        return (Boolean)this.data.get((Object)StateValue.DISARMED);
    }

    public void setDisarmed(boolean disarmed) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.DISARMED, disarmed);
        this.checkIsStillValid();
    }

    public int getDistance() {
        return (Integer)this.data.get((Object)StateValue.DISTANCE);
    }

    public void setDistance(int distance) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.DISTANCE, distance);
        this.checkIsStillValid();
    }

    public boolean isDown() {
        return (Boolean)this.data.get((Object)StateValue.DOWN);
    }

    public void setDown(boolean down) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.DOWN, down);
        this.checkIsStillValid();
    }

    public boolean isDrag() {
        return (Boolean)this.data.get((Object)StateValue.DRAG);
    }

    public void setDrag(boolean drag) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.DRAG, drag);
        this.checkIsStillValid();
    }

    public int getEggs() {
        return (Integer)this.data.get((Object)StateValue.EGGS);
    }

    public void setEggs(int eggs) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.EGGS, eggs);
        this.checkIsStillValid();
    }

    public boolean isEnabled() {
        return (Boolean)this.data.get((Object)StateValue.ENABLED);
    }

    public void setEnabled(boolean enabled) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.ENABLED, enabled);
        this.checkIsStillValid();
    }

    public boolean isExtended() {
        return (Boolean)this.data.get((Object)StateValue.EXTENDED);
    }

    public void setExtended(boolean extended) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.EXTENDED, extended);
        this.checkIsStillValid();
    }

    public boolean isEye() {
        return (Boolean)this.data.get((Object)StateValue.EYE);
    }

    public void setEye(boolean eye) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.EYE, eye);
        this.checkIsStillValid();
    }

    public Face getFace() {
        return (Face)((Object)this.data.get((Object)StateValue.FACE));
    }

    public void setFace(Face face) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.FACE, (Object)face);
        this.checkIsStillValid();
    }

    public BlockFace getFacing() {
        return (BlockFace)((Object)this.data.get((Object)StateValue.FACING));
    }

    public void setFacing(BlockFace facing) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.FACING, (Object)facing);
        this.checkIsStillValid();
    }

    public Half getHalf() {
        return (Half)((Object)this.data.get((Object)StateValue.HALF));
    }

    public void setHalf(Half half) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HALF, (Object)half);
        this.checkIsStillValid();
    }

    public boolean isHanging() {
        return (Boolean)this.data.get((Object)StateValue.HANGING);
    }

    public void setHanging(boolean hanging) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HANGING, hanging);
        this.checkIsStillValid();
    }

    public boolean isHasBook() {
        return (Boolean)this.data.get((Object)StateValue.HAS_BOOK);
    }

    public void setHasBook(boolean hasBook) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HAS_BOOK, hasBook);
        this.checkIsStillValid();
    }

    public boolean isHasBottle0() {
        return (Boolean)this.data.get((Object)StateValue.HAS_BOTTLE_0);
    }

    public void setHasBottle0(boolean hasBottle0) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HAS_BOTTLE_0, hasBottle0);
        this.checkIsStillValid();
    }

    public boolean isHasBottle1() {
        return (Boolean)this.data.get((Object)StateValue.HAS_BOTTLE_1);
    }

    public void setHasBottle1(boolean hasBottle1) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HAS_BOTTLE_1, hasBottle1);
        this.checkIsStillValid();
    }

    public boolean isHasBottle2() {
        return (Boolean)this.data.get((Object)StateValue.HAS_BOTTLE_2);
    }

    public void setHasBottle2(boolean hasBottle2) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HAS_BOTTLE_2, hasBottle2);
        this.checkIsStillValid();
    }

    public boolean isHasRecord() {
        return (Boolean)this.data.get((Object)StateValue.HAS_RECORD);
    }

    public void setHasRecord(boolean hasRecord) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HAS_RECORD, hasRecord);
        this.checkIsStillValid();
    }

    public int getHatch() {
        return (Integer)this.data.get((Object)StateValue.HATCH);
    }

    public void setHatch(int hatch) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HATCH, hatch);
        this.checkIsStillValid();
    }

    public Hinge getHinge() {
        return (Hinge)((Object)this.data.get((Object)StateValue.HINGE));
    }

    public void setHinge(Hinge hinge) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HINGE, (Object)hinge);
        this.checkIsStillValid();
    }

    public int getHoneyLevel() {
        return (Integer)this.data.get((Object)StateValue.HONEY_LEVEL);
    }

    public void setHoneyLevel(int honeyLevel) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HONEY_LEVEL, honeyLevel);
        this.checkIsStillValid();
    }

    public boolean isInWall() {
        return (Boolean)this.data.get((Object)StateValue.IN_WALL);
    }

    public void setInWall(boolean inWall) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.IN_WALL, inWall);
        this.checkIsStillValid();
    }

    public Instrument getInstrument() {
        return (Instrument)((Object)this.data.get((Object)StateValue.INSTRUMENT));
    }

    public void setInstrument(Instrument instrument) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.INSTRUMENT, (Object)instrument);
        this.checkIsStillValid();
    }

    public boolean isInverted() {
        return (Boolean)this.data.get((Object)StateValue.INVERTED);
    }

    public void setInverted(boolean inverted) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.INVERTED, inverted);
        this.checkIsStillValid();
    }

    public int getLayers() {
        return (Integer)this.data.get((Object)StateValue.LAYERS);
    }

    public void setLayers(int layers) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.LAYERS, layers);
        this.checkIsStillValid();
    }

    public Leaves getLeaves() {
        return (Leaves)((Object)this.data.get((Object)StateValue.LEAVES));
    }

    public void setLeaves(Leaves leaves) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.LEAVES, (Object)leaves);
        this.checkIsStillValid();
    }

    public int getLevel() {
        return (Integer)this.data.get((Object)StateValue.LEVEL);
    }

    public void setLevel(int level) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.LEVEL, level);
        this.checkIsStillValid();
    }

    public boolean isLit() {
        return (Boolean)this.data.get((Object)StateValue.LIT);
    }

    public void setLit(boolean lit) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.LIT, lit);
        this.checkIsStillValid();
    }

    public boolean isLocked() {
        return (Boolean)this.data.get((Object)StateValue.LOCKED);
    }

    public void setLocked(boolean locked) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.LOCKED, locked);
        this.checkIsStillValid();
    }

    public Mode getMode() {
        return (Mode)((Object)this.data.get((Object)StateValue.MODE));
    }

    public void setMode(Mode mode) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.MODE, (Object)mode);
        this.checkIsStillValid();
    }

    public int getMoisture() {
        return (Integer)this.data.get((Object)StateValue.MOISTURE);
    }

    public void setMoisture(int moisture) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.MOISTURE, moisture);
        this.checkIsStillValid();
    }

    public North getNorth() {
        return (North)((Object)this.data.get((Object)StateValue.NORTH));
    }

    public void setNorth(North north) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.NORTH, (Object)north);
        this.checkIsStillValid();
    }

    public int getNote() {
        return (Integer)this.data.get((Object)StateValue.NOTE);
    }

    public void setNote(int note) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.NOTE, note);
        this.checkIsStillValid();
    }

    public boolean isOccupied() {
        return (Boolean)this.data.get((Object)StateValue.OCCUPIED);
    }

    public void setOccupied(boolean occupied) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.OCCUPIED, occupied);
        this.checkIsStillValid();
    }

    public boolean isShrieking() {
        return (Boolean)this.data.get((Object)StateValue.SHRIEKING);
    }

    public void setShrieking(boolean shrieking) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SHRIEKING, shrieking);
        this.checkIsStillValid();
    }

    public boolean isCanSummon() {
        return (Boolean)this.data.get((Object)StateValue.CAN_SUMMON);
    }

    public void setCanSummon(boolean canSummon) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.CAN_SUMMON, canSummon);
        this.checkIsStillValid();
    }

    public boolean isOpen() {
        return (Boolean)this.data.get((Object)StateValue.OPEN);
    }

    public void setOpen(boolean open) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.OPEN, open);
        this.checkIsStillValid();
    }

    public Orientation getOrientation() {
        return (Orientation)((Object)this.data.get((Object)StateValue.ORIENTATION));
    }

    public void setOrientation(Orientation orientation) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.ORIENTATION, (Object)orientation);
        this.checkIsStillValid();
    }

    public Part getPart() {
        return (Part)((Object)this.data.get((Object)StateValue.PART));
    }

    public void setPart(Part part) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.PART, (Object)part);
        this.checkIsStillValid();
    }

    public boolean isPersistent() {
        return (Boolean)this.data.get((Object)StateValue.PERSISTENT);
    }

    public void setPersistent(boolean persistent) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.PERSISTENT, persistent);
        this.checkIsStillValid();
    }

    public int getPickles() {
        return (Integer)this.data.get((Object)StateValue.PICKLES);
    }

    public void setPickles(int pickles) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.PICKLES, pickles);
        this.checkIsStillValid();
    }

    public int getPower() {
        return (Integer)this.data.get((Object)StateValue.POWER);
    }

    public void setPower(int power) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.POWER, power);
        this.checkIsStillValid();
    }

    public boolean isPowered() {
        return (Boolean)this.data.get((Object)StateValue.POWERED);
    }

    public void setPowered(boolean powered) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.POWERED, powered);
        this.checkIsStillValid();
    }

    public int getRotation() {
        return (Integer)this.data.get((Object)StateValue.ROTATION);
    }

    public void setRotation(int rotation) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.ROTATION, rotation);
        this.checkIsStillValid();
    }

    public SculkSensorPhase getSculkSensorPhase() {
        return (SculkSensorPhase)((Object)this.data.get((Object)StateValue.SCULK_SENSOR_PHASE));
    }

    public void setSculkSensorPhase(SculkSensorPhase sculkSensorPhase) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SCULK_SENSOR_PHASE, (Object)sculkSensorPhase);
        this.checkIsStillValid();
    }

    public Shape getShape() {
        return (Shape)((Object)this.data.get((Object)StateValue.SHAPE));
    }

    public void setShape(Shape shape) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SHAPE, (Object)shape);
        this.checkIsStillValid();
    }

    public boolean isShort() {
        return (Boolean)this.data.get((Object)StateValue.SHORT);
    }

    public void setShort(boolean short_) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SHORT, short_);
        this.checkIsStillValid();
    }

    public boolean isSignalFire() {
        return (Boolean)this.data.get((Object)StateValue.SIGNAL_FIRE);
    }

    public void setSignalFire(boolean signalFire) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SIGNAL_FIRE, signalFire);
        this.checkIsStillValid();
    }

    public boolean isSlotZeroOccupied() {
        return (Boolean)this.data.get((Object)StateValue.SLOT_0_OCCUPIED);
    }

    public void setSlotZeroOccupied(boolean slotZeroOccupied) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SLOT_0_OCCUPIED, slotZeroOccupied);
        this.checkIsStillValid();
    }

    public boolean isSlotOneOccupied() {
        return (Boolean)this.data.get((Object)StateValue.SLOT_1_OCCUPIED);
    }

    public void setSlotOneOccupied(boolean slotOneOccupied) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SLOT_1_OCCUPIED, slotOneOccupied);
        this.checkIsStillValid();
    }

    public boolean isSlotTwoOccupied() {
        return (Boolean)this.data.get((Object)StateValue.SLOT_2_OCCUPIED);
    }

    public void setSlotTwoOccupied(boolean slotTwoOccupied) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SLOT_2_OCCUPIED, slotTwoOccupied);
        this.checkIsStillValid();
    }

    public boolean isSlotThreeOccupied() {
        return (Boolean)this.data.get((Object)StateValue.SLOT_3_OCCUPIED);
    }

    public void setSlotThreeOccupied(boolean slotThreeOccupied) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SLOT_3_OCCUPIED, slotThreeOccupied);
        this.checkIsStillValid();
    }

    public boolean isSlotFourOccupied() {
        return (Boolean)this.data.get((Object)StateValue.SLOT_4_OCCUPIED);
    }

    public void setSlotFourOccupied(boolean slotFourOccupied) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SLOT_4_OCCUPIED, slotFourOccupied);
        this.checkIsStillValid();
    }

    public boolean isSlotFiveOccupied() {
        return (Boolean)this.data.get((Object)StateValue.SLOT_5_OCCUPIED);
    }

    public void setSlotFiveOccupied(boolean slotFiveOccupied) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SLOT_5_OCCUPIED, slotFiveOccupied);
        this.checkIsStillValid();
    }

    public boolean isSnowy() {
        return (Boolean)this.data.get((Object)StateValue.SNOWY);
    }

    public void setSnowy(boolean snowy) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SNOWY, snowy);
        this.checkIsStillValid();
    }

    public int getStage() {
        return (Integer)this.data.get((Object)StateValue.STAGE);
    }

    public void setStage(int stage) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.STAGE, stage);
        this.checkIsStillValid();
    }

    public South getSouth() {
        return (South)((Object)this.data.get((Object)StateValue.SOUTH));
    }

    public void setSouth(South south) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SOUTH, (Object)south);
        this.checkIsStillValid();
    }

    public Thickness getThickness() {
        return (Thickness)((Object)this.data.get((Object)StateValue.THICKNESS));
    }

    public void setThickness(Thickness thickness) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.THICKNESS, (Object)thickness);
        this.checkIsStillValid();
    }

    public Tilt getTilt() {
        return (Tilt)((Object)this.data.get((Object)StateValue.TILT));
    }

    public void setTilt(Tilt tilt) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.TILT, (Object)tilt);
        this.checkIsStillValid();
    }

    public boolean isTriggered() {
        return (Boolean)this.data.get((Object)StateValue.TRIGGERED);
    }

    public void setTriggered(boolean triggered) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.TRIGGERED, triggered);
        this.checkIsStillValid();
    }

    public Type getTypeData() {
        return (Type)((Object)this.data.get((Object)StateValue.TYPE));
    }

    public void setTypeData(Type type) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.TYPE, (Object)type);
        this.checkIsStillValid();
    }

    public boolean isUnstable() {
        return (Boolean)this.data.get((Object)StateValue.UNSTABLE);
    }

    public void setUnstable(boolean unstable) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.UNSTABLE, unstable);
        this.checkIsStillValid();
    }

    public boolean isUp() {
        return (Boolean)this.data.get((Object)StateValue.UP);
    }

    public void setUp(boolean up) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.UP, up);
        this.checkIsStillValid();
    }

    public VerticalDirection getVerticalDirection() {
        return (VerticalDirection)((Object)this.data.get((Object)StateValue.VERTICAL_DIRECTION));
    }

    public void setVerticalDirection(VerticalDirection verticalDirection) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.VERTICAL_DIRECTION, (Object)verticalDirection);
        this.checkIsStillValid();
    }

    public boolean isWaterlogged() {
        return (Boolean)this.data.get((Object)StateValue.WATERLOGGED);
    }

    public void setWaterlogged(boolean waterlogged) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.WATERLOGGED, waterlogged);
        this.checkIsStillValid();
    }

    public East getEast() {
        return (East)((Object)this.data.get((Object)StateValue.EAST));
    }

    public void setEast(East west) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.EAST, (Object)west);
        this.checkIsStillValid();
    }

    public West getWest() {
        return (West)((Object)this.data.get((Object)StateValue.WEST));
    }

    public void setWest(West west) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.WEST, (Object)west);
        this.checkIsStillValid();
    }

    public Bloom getBloom() {
        return (Bloom)((Object)this.data.get((Object)StateValue.BLOOM));
    }

    public void setBloom(Bloom bloom) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.BLOOM, (Object)bloom);
        this.checkIsStillValid();
    }

    private void checkIfCloneNeeded() {
        if (!this.hasClonedData) {
            this.data = new HashMap<StateValue, Object>(this.data);
            this.hasClonedData = true;
        }
    }

    private void checkIsStillValid() {
        int oldGlobalID = this.globalID;
        this.globalID = this.getGlobalIdNoCache();
        if (this.globalID == -1) {
            WrappedBlockState blockState = BY_ID.get(this.mappingsIndex).getOrDefault(oldGlobalID, AIR).clone();
            this.type = blockState.type;
            this.globalID = blockState.globalID;
            this.data = new HashMap<StateValue, Object>(blockState.data);
            if (PacketEvents.getAPI().getSettings().isDebugEnabled()) {
                PacketEvents.getAPI().getLogManager().warn("Attempt to modify an unknown property for this game version and block!");
                PacketEvents.getAPI().getLogManager().warn("Block: " + this.type.getName());
                for (Map.Entry<StateValue, Object> entry : this.data.entrySet()) {
                    PacketEvents.getAPI().getLogManager().warn((Object)((Object)entry.getKey()) + ": " + entry.getValue());
                }
                new IllegalStateException("An invalid modification was made to a block!").printStackTrace();
            }
        }
    }

    @Deprecated
    public Map<StateValue, Object> getInternalData() {
        return this.data;
    }

    public int getGlobalId() {
        return this.globalID;
    }

    private int getGlobalIdNoCache() {
        return INTO_ID.get(this.mappingsIndex).getOrDefault(this, -1);
    }

    public String toString() {
        return INTO_STRING.get(this.mappingsIndex).get(this);
    }

    static {
        STRING_UPDATER.put("grass_path", "dirt_path");
        WrappedBlockState.loadLegacy();
        for (ClientVersion version : ClientVersion.values()) {
            if (!version.isNewerThanOrEquals(ClientVersion.V_1_13) || !version.isRelease()) continue;
            WrappedBlockState.loadModern(version);
        }
        cache = null;
    }
}

