/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.type;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.data.ParticleBlockStateData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.data.ParticleData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.data.ParticleDustColorTransitionData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.data.ParticleDustData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.data.ParticleItemStackData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.data.ParticleSculkChargeData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.data.ParticleShriekData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.data.ParticleVibrationData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.type.ParticleType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.TypesBuilder;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.TypesBuilderData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class ParticleTypes {
    private static final Map<String, ParticleType> PARTICLE_TYPE_MAP = new HashMap<String, ParticleType>();
    private static final Map<Byte, Map<Integer, ParticleType>> PARTICLE_TYPE_ID_MAP = new HashMap<Byte, Map<Integer, ParticleType>>();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("particle/particle_type_mappings", ClientVersion.V_1_12_2, ClientVersion.V_1_13, ClientVersion.V_1_13_2, ClientVersion.V_1_14, ClientVersion.V_1_15, ClientVersion.V_1_16, ClientVersion.V_1_16_2, ClientVersion.V_1_17, ClientVersion.V_1_18, ClientVersion.V_1_19, ClientVersion.V_1_19_4, ClientVersion.V_1_20);
    public static final ParticleType AMBIENT_ENTITY_EFFECT = ParticleTypes.define("ambient_entity_effect");
    public static final ParticleType ANGRY_VILLAGER = ParticleTypes.define("angry_villager");
    public static final ParticleType BLOCK = ParticleTypes.define("block", ParticleBlockStateData::read, (wrapper, data) -> ParticleBlockStateData.write(wrapper, (ParticleBlockStateData)data));
    public static final ParticleType BLOCK_MARKER = ParticleTypes.define("block_marker", ParticleBlockStateData::read, (wrapper, data) -> ParticleBlockStateData.write(wrapper, (ParticleBlockStateData)data));
    public static final ParticleType BUBBLE = ParticleTypes.define("bubble");
    public static final ParticleType CLOUD = ParticleTypes.define("cloud");
    public static final ParticleType CRIT = ParticleTypes.define("crit");
    public static final ParticleType DAMAGE_INDICATOR = ParticleTypes.define("damage_indicator");
    public static final ParticleType DRAGON_BREATH = ParticleTypes.define("dragon_breath");
    public static final ParticleType DRIPPING_LAVA = ParticleTypes.define("dripping_lava");
    public static final ParticleType FALLING_LAVA = ParticleTypes.define("falling_lava");
    public static final ParticleType LANDING_LAVA = ParticleTypes.define("landing_lava");
    public static final ParticleType DRIPPING_WATER = ParticleTypes.define("dripping_water");
    public static final ParticleType FALLING_WATER = ParticleTypes.define("falling_water");
    public static final ParticleType DUST = ParticleTypes.define("dust", ParticleDustData::read, (wrapper, data) -> ParticleDustData.write(wrapper, (ParticleDustData)data));
    public static final ParticleType DUST_COLOR_TRANSITION = ParticleTypes.define("dust_color_transition", ParticleDustColorTransitionData::read, (wrapper, data) -> ParticleDustColorTransitionData.write(wrapper, (ParticleDustColorTransitionData)data));
    public static final ParticleType EFFECT = ParticleTypes.define("effect");
    public static final ParticleType ELDER_GUARDIAN = ParticleTypes.define("elder_guardian");
    public static final ParticleType ENCHANTED_HIT = ParticleTypes.define("enchanted_hit");
    public static final ParticleType ENCHANT = ParticleTypes.define("enchant");
    public static final ParticleType END_ROD = ParticleTypes.define("end_rod");
    public static final ParticleType ENTITY_EFFECT = ParticleTypes.define("entity_effect");
    public static final ParticleType EXPLOSION_EMITTER = ParticleTypes.define("explosion_emitter");
    public static final ParticleType EXPLOSION = ParticleTypes.define("explosion");
    public static final ParticleType SONIC_BOOM = ParticleTypes.define("sonic_boom");
    public static final ParticleType FALLING_DUST = ParticleTypes.define("falling_dust", ParticleBlockStateData::read, (wrapper, data) -> ParticleBlockStateData.write(wrapper, (ParticleBlockStateData)data));
    public static final ParticleType FIREWORK = ParticleTypes.define("firework");
    public static final ParticleType FISHING = ParticleTypes.define("fishing");
    public static final ParticleType FLAME = ParticleTypes.define("flame");
    public static final ParticleType SCULK_SOUL = ParticleTypes.define("sculk_soul");
    public static final ParticleType SCULK_CHARGE = ParticleTypes.define("sculk_charge", ParticleSculkChargeData::read, (wrapper, data) -> ParticleSculkChargeData.write(wrapper, (ParticleSculkChargeData)data));
    public static final ParticleType SCULK_CHARGE_POP = ParticleTypes.define("sculk_charge_pop");
    public static final ParticleType SOUL_FIRE_FLAME = ParticleTypes.define("soul_fire_flame");
    public static final ParticleType SOUL = ParticleTypes.define("soul");
    public static final ParticleType FLASH = ParticleTypes.define("flash");
    public static final ParticleType HAPPY_VILLAGER = ParticleTypes.define("happy_villager");
    public static final ParticleType COMPOSTER = ParticleTypes.define("composter");
    public static final ParticleType HEART = ParticleTypes.define("heart");
    public static final ParticleType INSTANT_EFFECT = ParticleTypes.define("instant_effect");
    public static final ParticleType ITEM = ParticleTypes.define("item", ParticleItemStackData::read, (wrapper, data) -> ParticleItemStackData.write(wrapper, (ParticleItemStackData)data));
    public static final ParticleType VIBRATION = ParticleTypes.define("vibration", ParticleVibrationData::read, (wrapper, data) -> ParticleVibrationData.write(wrapper, (ParticleVibrationData)data));
    public static final ParticleType ITEM_SLIME = ParticleTypes.define("item_slime");
    public static final ParticleType ITEM_SNOWBALL = ParticleTypes.define("item_snowball");
    public static final ParticleType LARGE_SMOKE = ParticleTypes.define("large_smoke");
    public static final ParticleType LAVA = ParticleTypes.define("lava");
    public static final ParticleType MYCELIUM = ParticleTypes.define("mycelium");
    public static final ParticleType NOTE = ParticleTypes.define("note");
    public static final ParticleType POOF = ParticleTypes.define("poof");
    public static final ParticleType PORTAL = ParticleTypes.define("portal");
    public static final ParticleType RAIN = ParticleTypes.define("rain");
    public static final ParticleType SMOKE = ParticleTypes.define("smoke");
    public static final ParticleType SNEEZE = ParticleTypes.define("sneeze");
    public static final ParticleType SPIT = ParticleTypes.define("spit");
    public static final ParticleType SQUID_INK = ParticleTypes.define("squid_ink");
    public static final ParticleType SWEEP_ATTACK = ParticleTypes.define("sweep_attack");
    public static final ParticleType TOTEM_OF_UNDYING = ParticleTypes.define("totem_of_undying");
    public static final ParticleType UNDERWATER = ParticleTypes.define("underwater");
    public static final ParticleType SPLASH = ParticleTypes.define("splash");
    public static final ParticleType WITCH = ParticleTypes.define("witch");
    public static final ParticleType BUBBLE_POP = ParticleTypes.define("bubble_pop");
    public static final ParticleType CURRENT_DOWN = ParticleTypes.define("current_down");
    public static final ParticleType BUBBLE_COLUMN_UP = ParticleTypes.define("bubble_column_up");
    public static final ParticleType NAUTILUS = ParticleTypes.define("nautilus");
    public static final ParticleType DOLPHIN = ParticleTypes.define("dolphin");
    public static final ParticleType CAMPFIRE_COSY_SMOKE = ParticleTypes.define("campfire_cosy_smoke");
    public static final ParticleType CAMPFIRE_SIGNAL_SMOKE = ParticleTypes.define("campfire_signal_smoke");
    public static final ParticleType DRIPPING_HONEY = ParticleTypes.define("dripping_honey");
    public static final ParticleType FALLING_HONEY = ParticleTypes.define("falling_honey");
    public static final ParticleType LANDING_HONEY = ParticleTypes.define("landing_honey");
    public static final ParticleType FALLING_NECTAR = ParticleTypes.define("falling_nectar");
    public static final ParticleType FALLING_SPORE_BLOSSOM = ParticleTypes.define("falling_spore_blossom");
    public static final ParticleType ASH = ParticleTypes.define("ash");
    public static final ParticleType CRIMSON_SPORE = ParticleTypes.define("crimson_spore");
    public static final ParticleType WARPED_SPORE = ParticleTypes.define("warped_spore");
    public static final ParticleType SPORE_BLOSSOM_AIR = ParticleTypes.define("spore_blossom_air");
    public static final ParticleType DRIPPING_OBSIDIAN_TEAR = ParticleTypes.define("dripping_obsidian_tear");
    public static final ParticleType FALLING_OBSIDIAN_TEAR = ParticleTypes.define("falling_obsidian_tear");
    public static final ParticleType LANDING_OBSIDIAN_TEAR = ParticleTypes.define("landing_obsidian_tear");
    public static final ParticleType REVERSE_PORTAL = ParticleTypes.define("reverse_portal");
    public static final ParticleType WHITE_ASH = ParticleTypes.define("white_ash");
    public static final ParticleType SMALL_FLAME = ParticleTypes.define("small_flame");
    public static final ParticleType SNOWFLAKE = ParticleTypes.define("snowflake");
    public static final ParticleType DRIPPING_DRIPSTONE_LAVA = ParticleTypes.define("dripping_dripstone_lava");
    public static final ParticleType FALLING_DRIPSTONE_LAVA = ParticleTypes.define("falling_dripstone_lava");
    public static final ParticleType DRIPPING_DRIPSTONE_WATER = ParticleTypes.define("dripping_dripstone_water");
    public static final ParticleType FALLING_DRIPSTONE_WATER = ParticleTypes.define("falling_dripstone_water");
    public static final ParticleType GLOW_SQUID_INK = ParticleTypes.define("glow_squid_ink");
    public static final ParticleType GLOW = ParticleTypes.define("glow");
    public static final ParticleType WAX_ON = ParticleTypes.define("wax_on");
    public static final ParticleType WAX_OFF = ParticleTypes.define("wax_off");
    public static final ParticleType ELECTRIC_SPARK = ParticleTypes.define("electric_spark");
    public static final ParticleType SCRAPE = ParticleTypes.define("scrape");
    public static final ParticleType SHRIEK = ParticleTypes.define("shriek", ParticleShriekData::read, (wrapper, data) -> ParticleShriekData.write(wrapper, (ParticleShriekData)data));
    public static final ParticleType DRIPPING_CHERRY_LEAVES = ParticleTypes.define("dripping_cherry_leaves");
    public static final ParticleType FALLING_CHERRY_LEAVES = ParticleTypes.define("falling_cherry_leaves");
    public static final ParticleType LANDING_CHERRY_LEAVES = ParticleTypes.define("landing_cherry_leaves");
    public static final ParticleType CHERRY_LEAVES = ParticleTypes.define("cherry_leaves");
    public static final ParticleType EGG_CRACK = ParticleTypes.define("egg_crack");

    public static ParticleType define(String key, final Function<PacketWrapper<?>, ParticleData> readDataFunction, final BiConsumer<PacketWrapper<?>, ParticleData> writeDataFunction) {
        final TypesBuilderData data = TYPES_BUILDER.defineFromArray(key);
        ParticleType particleType = new ParticleType(){
            private final int[] ids;
            {
                this.ids = data.getData();
            }

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                int index = TYPES_BUILDER.getDataIndex(version);
                return this.ids[index];
            }

            @Override
            public Function<PacketWrapper<?>, ParticleData> readDataFunction() {
                return readDataFunction;
            }

            @Override
            public BiConsumer<PacketWrapper<?>, ParticleData> writeDataFunction() {
                return writeDataFunction;
            }

            public boolean equals(Object obj) {
                if (obj instanceof ParticleType) {
                    return this.getName().equals(((ParticleType)obj).getName());
                }
                return false;
            }
        };
        PARTICLE_TYPE_MAP.put(particleType.getName().toString(), particleType);
        for (ClientVersion version : TYPES_BUILDER.getVersions()) {
            int index = TYPES_BUILDER.getDataIndex(version);
            Map typeIdMap = PARTICLE_TYPE_ID_MAP.computeIfAbsent((byte)index, k -> new HashMap());
            typeIdMap.put(particleType.getId(version), particleType);
        }
        return particleType;
    }

    public static ParticleType define(String key) {
        return ParticleTypes.define(key, wrapper -> new ParticleData(), (wrapper, data) -> {});
    }

    public static ParticleType getByName(String name) {
        return PARTICLE_TYPE_MAP.get(name);
    }

    public static ParticleType getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, ParticleType> typeIdMap = PARTICLE_TYPE_ID_MAP.get((byte)index);
        return typeIdMap.get(id);
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }
}

