/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.data;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.particle.data.ParticleData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.Vector3i;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class ParticleVibrationData
extends ParticleData {
    private Vector3i startingPosition;
    private PositionType type;
    @Nullable
    private Vector3i blockPosition;
    @Nullable
    private Integer entityId;
    private int ticks;

    public ParticleVibrationData(Vector3i startingPosition, @Nullable Vector3i blockPosition, int ticks) {
        this.startingPosition = startingPosition;
        this.type = PositionType.BLOCK;
        this.blockPosition = blockPosition;
        this.entityId = null;
        this.ticks = ticks;
    }

    public ParticleVibrationData(Vector3i startingPosition, int entityId, int ticks) {
        this.startingPosition = startingPosition;
        this.type = PositionType.ENTITY;
        this.blockPosition = null;
        this.entityId = entityId;
        this.ticks = ticks;
    }

    public Vector3i getStartingPosition() {
        return this.startingPosition;
    }

    public void setStartingPosition(Vector3i startingPosition) {
        this.startingPosition = startingPosition;
    }

    public PositionType getType() {
        return this.type;
    }

    public Optional<Vector3i> getBlockPosition() {
        return Optional.ofNullable(this.blockPosition);
    }

    public void setBlockPosition(@Nullable Vector3i blockPosition) {
        this.blockPosition = blockPosition;
    }

    public Optional<Integer> getEntityId() {
        return Optional.ofNullable(this.entityId);
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public static ParticleVibrationData read(PacketWrapper<?> wrapper) {
        Vector3i startingPos = wrapper.readBlockPosition();
        String positionTypeName = wrapper.readString();
        PositionType positionType = PositionType.getByName(positionTypeName);
        if (positionType == PositionType.BLOCK) {
            return new ParticleVibrationData(startingPos, wrapper.readBlockPosition(), wrapper.readVarInt());
        }
        if (positionType == PositionType.ENTITY) {
            return new ParticleVibrationData(startingPos, wrapper.readVarInt(), wrapper.readVarInt());
        }
        throw new IllegalArgumentException("Unknown position type: " + positionTypeName);
    }

    public static void write(PacketWrapper<?> wrapper, ParticleVibrationData data) {
        wrapper.writeBlockPosition(data.getStartingPosition());
        wrapper.writeString(data.getType().getName());
        if (data.getType() == PositionType.BLOCK) {
            wrapper.writeBlockPosition(data.getBlockPosition().get());
        } else if (data.getType() == PositionType.ENTITY) {
            wrapper.writeVarInt(data.getEntityId().get());
        }
        wrapper.writeVarInt(data.getTicks());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public static enum PositionType {
        BLOCK("minecraft:block"),
        ENTITY("minecraft:entity");

        private final String name;

        private PositionType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static PositionType getByName(String name) {
            for (PositionType type : PositionType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }
    }
}

