/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.codec;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.netty.buffer.ByteBufHelper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.netty.buffer.ByteBufInputStream;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.netty.buffer.ByteBufOutputStream;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBT;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTByte;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTCompound;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTDouble;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTEnd;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTFloat;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTInt;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTList;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTLong;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTNumber;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTShort;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTString;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.serializer.DefaultNBTSerializer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LazilyParsedNumber;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class NBTCodec {
    public static NBT jsonToNBT(JsonElement element) {
        if (element instanceof JsonPrimitive) {
            if (((JsonPrimitive)element).isBoolean()) {
                return new NBTByte(element.getAsBoolean());
            }
            if (((JsonPrimitive)element).isString()) {
                return new NBTString(element.getAsString());
            }
            if (((JsonPrimitive)element).isNumber()) {
                Number num = element.getAsNumber();
                if (num instanceof Float) {
                    return new NBTFloat(num.floatValue());
                }
                if (num instanceof Double) {
                    return new NBTDouble(num.doubleValue());
                }
                if (num instanceof Byte) {
                    return new NBTByte(num.byteValue());
                }
                if (num instanceof Short) {
                    return new NBTShort(num.shortValue());
                }
                if (num instanceof Integer || num instanceof LazilyParsedNumber) {
                    return new NBTInt(num.intValue());
                }
                if (num instanceof Long) {
                    return new NBTLong(num.longValue());
                }
            }
        } else {
            if (element instanceof JsonArray) {
                ArrayList<NBT> list = new ArrayList<NBT>();
                for (JsonElement var : (JsonArray)element) {
                    list.add(NBTCodec.jsonToNBT(var));
                }
                if (list.isEmpty()) {
                    return new NBTList<NBTCompound>(NBTType.COMPOUND);
                }
                NBTList l = new NBTList(((NBT)list.get(0)).getType());
                for (NBT nbt : list) {
                    l.addTagUnsafe(nbt);
                }
                return l;
            }
            if (element instanceof JsonObject) {
                JsonObject obj = (JsonObject)element;
                NBTCompound compound = new NBTCompound();
                for (Map.Entry<String, JsonElement> jsonEntry : obj.entrySet()) {
                    compound.setTag(jsonEntry.getKey(), NBTCodec.jsonToNBT(jsonEntry.getValue()));
                }
                return compound;
            }
            if (element instanceof JsonNull || element == null) {
                return new NBTCompound();
            }
        }
        throw new IllegalStateException("Failed to convert JSON to NBT " + element.toString());
    }

    public static JsonElement nbtToJson(NBT nbt, boolean parseByteAsBool) {
        if (nbt instanceof NBTNumber) {
            if (nbt instanceof NBTByte && parseByteAsBool) {
                byte val = ((NBTByte)nbt).getAsByte();
                if (val == 0) {
                    return new JsonPrimitive(false);
                }
                if (val == 1) {
                    return new JsonPrimitive(true);
                }
            }
            return new JsonPrimitive(((NBTNumber)nbt).getAsNumber());
        }
        if (nbt instanceof NBTString) {
            return new JsonPrimitive(((NBTString)nbt).getValue());
        }
        if (nbt instanceof NBTList) {
            NBTList list = (NBTList)nbt;
            JsonArray jsonArray = new JsonArray();
            list.getTags().forEach(tag -> jsonArray.add(NBTCodec.nbtToJson(tag, parseByteAsBool)));
            return jsonArray;
        }
        if (nbt instanceof NBTEnd) {
            throw new IllegalStateException("Encountered the NBTEnd tag during the NBT to JSON conversion: " + nbt.toString());
        }
        if (nbt instanceof NBTCompound) {
            JsonObject jsonObject = new JsonObject();
            Map<String, NBT> compoundTags = ((NBTCompound)nbt).getTags();
            for (String tagName : compoundTags.keySet()) {
                NBT tag2 = compoundTags.get(tagName);
                JsonElement jsonValue = NBTCodec.nbtToJson(tag2, parseByteAsBool);
                jsonObject.add(tagName, jsonValue);
            }
            return jsonObject;
        }
        throw new IllegalStateException("Failed to convert NBT to JSON.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NBTCompound readNBTFromBuffer(Object byteBuf, ServerVersion serverVersion) {
        if (serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            try {
                boolean named = serverVersion.isOlderThan(ServerVersion.V_1_20_2);
                return (NBTCompound)DefaultNBTSerializer.INSTANCE.deserializeTag(new ByteBufInputStream(byteBuf), named);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            short length = ByteBufHelper.readShort(byteBuf);
            if (length < 0) {
                return null;
            }
            Object slicedBuffer = ByteBufHelper.readSlice(byteBuf, length);
            try (DataInputStream stream = new DataInputStream(new GZIPInputStream(new ByteBufInputStream(slicedBuffer)));){
                NBTCompound nBTCompound = (NBTCompound)DefaultNBTSerializer.INSTANCE.deserializeTag(stream);
                return nBTCompound;
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static void writeNBTToBuffer(Object byteBuf, ServerVersion serverVersion, NBTCompound tag) {
        if (serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            try (ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);){
                if (tag != null) {
                    boolean named = serverVersion.isOlderThan(ServerVersion.V_1_20_2);
                    DefaultNBTSerializer.INSTANCE.serializeTag(outputStream, tag, named);
                }
                DefaultNBTSerializer.INSTANCE.serializeTag(outputStream, NBTEnd.INSTANCE);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else if (tag == null) {
            ByteBufHelper.writeShort(byteBuf, -1);
        } else {
            int lengthWriterIndex = ByteBufHelper.writerIndex(byteBuf);
            ByteBufHelper.writeShort(byteBuf, 0);
            int writerIndexDataStart = ByteBufHelper.writerIndex(byteBuf);
            try (DataOutputStream outputstream = new DataOutputStream(new GZIPOutputStream(new ByteBufOutputStream(byteBuf)));){
                DefaultNBTSerializer.INSTANCE.serializeTag(outputstream, tag);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            int writerIndexDataEnd = ByteBufHelper.writerIndex(byteBuf);
            ByteBufHelper.writerIndex(byteBuf, lengthWriterIndex);
            ByteBufHelper.writeShort(byteBuf, writerIndexDataEnd - writerIndexDataStart);
            ByteBufHelper.writerIndex(byteBuf, writerIndexDataEnd);
        }
    }
}

