/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBT;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTByte;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTList;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTNumber;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTString;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class NBTCompound
extends NBT {
    protected final Map<String, NBT> tags = new LinkedHashMap<String, NBT>();

    public NBTType<NBTCompound> getType() {
        return NBTType.COMPOUND;
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    public Set<String> getTagNames() {
        return Collections.unmodifiableSet(this.tags.keySet());
    }

    public Map<String, NBT> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public NBT getTagOrThrow(String key) {
        NBT tag = this.getTagOrNull(key);
        if (tag == null) {
            throw new IllegalStateException(MessageFormat.format("NBT {0} does not exist", key));
        }
        return tag;
    }

    public NBT getTagOrNull(String key) {
        return this.tags.get(key);
    }

    public <T extends NBT> T getTagOfTypeOrThrow(String key, Class<T> type) {
        NBT tag = this.getTagOrThrow(key);
        if (type.isInstance(tag)) {
            return (T)tag;
        }
        throw new IllegalStateException(MessageFormat.format("NBT {0} has unexpected type, expected {1}, but got {2}", key, type, tag.getClass()));
    }

    public <T extends NBT> T getTagOfTypeOrNull(String key, Class<T> type) {
        NBT tag = this.getTagOrNull(key);
        if (type.isInstance(tag)) {
            return (T)tag;
        }
        return null;
    }

    public <T extends NBT> NBTList<T> getTagListOfTypeOrThrow(String key, Class<T> type) {
        NBTList list = this.getTagOfTypeOrThrow(key, NBTList.class);
        if (!type.isAssignableFrom(list.getTagsType().getNBTClass())) {
            throw new IllegalStateException(MessageFormat.format("NBTList {0} tags type has unexpected type, expected {1}, but got {2}", key, type, list.getTagsType().getNBTClass()));
        }
        return list;
    }

    public <T extends NBT> NBTList<T> getTagListOfTypeOrNull(String key, Class<T> type) {
        NBTList list = this.getTagOfTypeOrNull(key, NBTList.class);
        if (list != null && type.isAssignableFrom(list.getTagsType().getNBTClass())) {
            return list;
        }
        return null;
    }

    public NBTCompound getCompoundTagOrThrow(String key) {
        return this.getTagOfTypeOrThrow(key, NBTCompound.class);
    }

    public NBTCompound getCompoundTagOrNull(String key) {
        return this.getTagOfTypeOrNull(key, NBTCompound.class);
    }

    public NBTNumber getNumberTagOrThrow(String key) {
        return this.getTagOfTypeOrThrow(key, NBTNumber.class);
    }

    public NBTNumber getNumberTagOrNull(String key) {
        return this.getTagOfTypeOrNull(key, NBTNumber.class);
    }

    public NBTString getStringTagOrThrow(String key) {
        return this.getTagOfTypeOrThrow(key, NBTString.class);
    }

    public NBTString getStringTagOrNull(String key) {
        return this.getTagOfTypeOrNull(key, NBTString.class);
    }

    public NBTList<NBTCompound> getCompoundListTagOrThrow(String key) {
        return this.getTagListOfTypeOrThrow(key, NBTCompound.class);
    }

    public NBTList<NBTCompound> getCompoundListTagOrNull(String key) {
        return this.getTagListOfTypeOrNull(key, NBTCompound.class);
    }

    public NBTList<NBTNumber> getNumberTagListTagOrThrow(String key) {
        return this.getTagListOfTypeOrThrow(key, NBTNumber.class);
    }

    public NBTList<NBTNumber> getNumberListTagOrNull(String key) {
        return this.getTagListOfTypeOrNull(key, NBTNumber.class);
    }

    public NBTList<NBTString> getStringListTagOrThrow(String key) {
        return this.getTagListOfTypeOrThrow(key, NBTString.class);
    }

    public NBTList<NBTString> getStringListTagOrNull(String key) {
        return this.getTagListOfTypeOrNull(key, NBTString.class);
    }

    public String getStringTagValueOrThrow(String key) {
        return this.getStringTagOrThrow(key).getValue();
    }

    public String getStringTagValueOrNull(String key) {
        NBT tag = this.getTagOrNull(key);
        if (tag instanceof NBTString) {
            return ((NBTString)tag).getValue();
        }
        return null;
    }

    public String getStringTagValueOrDefault(String key, String defaultValue) {
        NBT tag = this.getTagOrNull(key);
        if (tag instanceof NBTString) {
            return ((NBTString)tag).getValue();
        }
        return defaultValue;
    }

    public NBT removeTag(String key) {
        return this.tags.remove(key);
    }

    public <T extends NBT> T removeTagAndReturnIfType(String key, Class<T> type) {
        NBT tag = this.removeTag(key);
        if (type.isInstance(tag)) {
            return (T)tag;
        }
        return null;
    }

    public <T extends NBT> NBTList<T> removeTagAndReturnIfListType(String key, Class<T> type) {
        NBTList list = this.removeTagAndReturnIfType(key, NBTList.class);
        if (list != null && type.isAssignableFrom(list.getTagsType().getNBTClass())) {
            return list;
        }
        return null;
    }

    public void setTag(String key, NBT tag) {
        if (tag != null) {
            this.tags.put(key, tag);
        } else {
            this.tags.remove(key);
        }
    }

    @Override
    public NBTCompound copy() {
        NBTCompound clone = new NBTCompound();
        for (Map.Entry<String, NBT> entry : this.tags.entrySet()) {
            clone.setTag(entry.getKey(), entry.getValue().copy());
        }
        return clone;
    }

    public boolean getBoolean(String string) {
        NBTByte nbtByte = this.getTagOfTypeOrNull(string, NBTByte.class);
        return nbtByte != null && nbtByte.getAsByte() != 0;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof NBTCompound) {
            if (this.isEmpty() && ((NBTCompound)other).isEmpty()) {
                return true;
            }
            return this.tags.equals(((NBTCompound)other).tags);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.tags.hashCode();
    }
}

