/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.chat;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.chat.ChatType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.TypesBuilder;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.TypesBuilderData;
import java.util.HashMap;
import java.util.Map;

public class ChatTypes {
    private static final Map<String, ChatType> CHAT_TYPE_MAP = new HashMap<String, ChatType>();
    private static final Map<Byte, Map<Integer, ChatType>> CHAT_TYPE_ID_MAP = new HashMap<Byte, Map<Integer, ChatType>>();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("chat/chat_type_mappings", ClientVersion.V_1_18_2, ClientVersion.V_1_19, ClientVersion.V_1_19_1);
    public static final ChatType CHAT;
    public static final ChatType SAY_COMMAND;
    public static final ChatType MSG_COMMAND_INCOMING;
    public static final ChatType MSG_COMMAND_OUTGOING;
    public static final ChatType TEAM_MSG_COMMAND_INCOMING;
    public static final ChatType TEAM_MSG_COMMAND_OUTGOING;
    public static final ChatType EMOTE_COMMAND;
    public static final ChatType RAW;
    @Deprecated
    public static final ChatType SYSTEM;
    @Deprecated
    public static final ChatType GAME_INFO;
    @Deprecated
    public static final ChatType MSG_COMMAND;
    @Deprecated
    public static final ChatType TEAM_MSG_COMMAND;

    public static ChatType define(String key) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        ChatType chatType = new ChatType(){
            private final int[] ids;
            {
                this.ids = data.getData();
            }

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                int index = TYPES_BUILDER.getDataIndex(version);
                return this.ids[index];
            }
        };
        CHAT_TYPE_MAP.put(chatType.getName().toString(), chatType);
        for (ClientVersion version : TYPES_BUILDER.getVersions()) {
            int index = TYPES_BUILDER.getDataIndex(version);
            Map typeIdMap = CHAT_TYPE_ID_MAP.computeIfAbsent((byte)index, k -> new HashMap());
            typeIdMap.put(chatType.getId(version), chatType);
        }
        return chatType;
    }

    public static ChatType getByName(String name) {
        return CHAT_TYPE_MAP.get(name);
    }

    public static ChatType getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        return CHAT_TYPE_ID_MAP.get((byte)index).get(id);
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
        CHAT = ChatTypes.define("chat");
        SAY_COMMAND = ChatTypes.define("say_command");
        MSG_COMMAND_INCOMING = ChatTypes.define("msg_command_incoming");
        MSG_COMMAND_OUTGOING = ChatTypes.define("msg_command_outgoing");
        TEAM_MSG_COMMAND_INCOMING = ChatTypes.define("team_msg_command_incoming");
        TEAM_MSG_COMMAND_OUTGOING = ChatTypes.define("team_msg_command_outgoing");
        EMOTE_COMMAND = ChatTypes.define("emote_command");
        RAW = ChatTypes.define("raw");
        SYSTEM = ChatTypes.define("system");
        GAME_INFO = ChatTypes.define("game_info");
        MSG_COMMAND = ChatTypes.define("msg_command");
        TEAM_MSG_COMMAND = ChatTypes.define("team_msg_command");
    }
}

