/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEvents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketListenerAbstract;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketListenerPriority;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketReceiveEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketSendEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.protocol.ProtocolManager;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.ConnectionState;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTCompound;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.nbt.NBTList;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.User;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.UserProfile;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.configuration.server.WrapperConfigServerRegistryData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.handshaking.client.WrapperHandshakingClientHandshake;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.login.server.WrapperLoginServerLoginSuccess;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerJoinGame;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerRespawn;
import java.net.InetSocketAddress;

public class InternalPacketListener
extends PacketListenerAbstract {
    public InternalPacketListener() {
        this(PacketListenerPriority.LOWEST);
    }

    public InternalPacketListener(PacketListenerPriority priority) {
        super(priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPacketSend(PacketSendEvent event) {
        User user = event.getUser();
        if (event.getPacketType() == PacketType.Login.Server.LOGIN_SUCCESS) {
            Object channel = event.getChannel();
            WrapperLoginServerLoginSuccess loginSuccess = new WrapperLoginServerLoginSuccess(event);
            UserProfile profile = loginSuccess.getUserProfile();
            user.getProfile().setUUID(profile.getUUID());
            user.getProfile().setName(profile.getName());
            user.getProfile().setTextureProperties(profile.getTextureProperties());
            Object object = channel;
            synchronized (object) {
                ProtocolManager.CHANNELS.put(profile.getUUID(), channel);
            }
            PacketEvents.getAPI().getLogManager().debug("Mapped player UUID with their channel.");
            boolean proxy = PacketEvents.getAPI().getInjector().isProxy();
            if (proxy ? event.getUser().getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_20_2) : event.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_2)) {
                user.setEncoderState(ConnectionState.CONFIGURATION);
            } else {
                user.setConnectionState(ConnectionState.PLAY);
            }
        } else if (event.getPacketType() == PacketType.Configuration.Server.REGISTRY_DATA) {
            WrapperConfigServerRegistryData registryData = new WrapperConfigServerRegistryData(event);
            NBTCompound registryDataTag = registryData.getRegistryData();
            if (registryDataTag != null) {
                NBTList<NBTCompound> list = registryDataTag.getCompoundTagOrNull("minecraft:dimension_type").getCompoundListTagOrNull("value");
                user.setWorldNBT(list);
            }
        } else if (event.getPacketType() == PacketType.Play.Server.JOIN_GAME) {
            NBTCompound dimension;
            WrapperPlayServerJoinGame joinGame = new WrapperPlayServerJoinGame(event);
            user.setEntityId(joinGame.getEntityId());
            user.setDimension(joinGame.getDimension());
            if (event.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_16_5)) {
                return;
            }
            NBTCompound dimensionCodec = joinGame.getDimensionCodec();
            if (dimensionCodec != null) {
                NBTList<NBTCompound> list = dimensionCodec.getCompoundTagOrNull("minecraft:dimension_type").getCompoundListTagOrNull("value");
                user.setWorldNBT(list);
            }
            if ((dimension = user.getWorldNBT(joinGame.getDimension().getDimensionName())) != null) {
                NBTCompound worldNBT = dimension.getCompoundTagOrNull("element");
                user.setMinWorldHeight(worldNBT.getNumberTagOrNull("min_y").getAsInt());
                user.setTotalWorldHeight(worldNBT.getNumberTagOrNull("height").getAsInt());
            }
        } else if (event.getPacketType() == PacketType.Play.Server.RESPAWN) {
            WrapperPlayServerRespawn respawn = new WrapperPlayServerRespawn(event);
            user.setDimension(respawn.getDimension());
            if (event.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_16_5)) {
                return;
            }
            NBTCompound dimension = user.getWorldNBT(respawn.getDimension().getDimensionName());
            if (dimension != null) {
                NBTCompound worldNBT = dimension.getCompoundTagOrNull("element");
                user.setMinWorldHeight(worldNBT.getNumberTagOrNull("min_y").getAsInt());
                user.setTotalWorldHeight(worldNBT.getNumberTagOrNull("height").getAsInt());
            }
        } else if (event.getPacketType() == PacketType.Play.Server.CONFIGURATION_START) {
            user.setEncoderState(ConnectionState.CONFIGURATION);
        } else if (event.getPacketType() == PacketType.Configuration.Server.CONFIGURATION_END) {
            user.setEncoderState(ConnectionState.PLAY);
        }
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        User user = event.getUser();
        if (event.getPacketType() == PacketType.Handshaking.Client.HANDSHAKE) {
            Object channel = event.getChannel();
            InetSocketAddress address = event.getSocketAddress();
            WrapperHandshakingClientHandshake handshake = new WrapperHandshakingClientHandshake(event);
            ConnectionState nextState = handshake.getNextConnectionState();
            ClientVersion clientVersion = handshake.getClientVersion();
            user.setClientVersion(clientVersion);
            PacketEvents.getAPI().getLogManager().debug("Processed " + address.getHostString() + ":" + address.getPort() + "'s client version. Client Version: " + clientVersion.getReleaseName());
            user.setConnectionState(nextState);
        } else if (event.getPacketType() == PacketType.Login.Client.LOGIN_SUCCESS_ACK) {
            user.setDecoderState(ConnectionState.CONFIGURATION);
        } else if (event.getPacketType() == PacketType.Play.Client.CONFIGURATION_ACK) {
            user.setDecoderState(ConnectionState.CONFIGURATION);
        } else if (event.getPacketType() == PacketType.Configuration.Client.CONFIGURATION_END_ACK) {
            user.setDecoderState(ConnectionState.PLAY);
        }
    }
}

