/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEvents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketListener;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketListenerAbstract;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketListenerCommon;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketListenerPriority;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.ProtocolPacketEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.exception.InvalidHandshakeException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.jetbrains.annotations.Nullable;

public class EventManager {
    private final Map<Byte, Set<PacketListenerCommon>> listenersMap = new ConcurrentHashMap<Byte, Set<PacketListenerCommon>>();

    public void callEvent(PacketEvent event) {
        this.callEvent(event, null);
    }

    public void callEvent(PacketEvent event, @Nullable Runnable postCallListenerAction) {
        for (byte priority = PacketListenerPriority.LOWEST.getId(); priority <= PacketListenerPriority.MONITOR.getId(); priority = (byte)(priority + 1)) {
            Set<PacketListenerCommon> listeners = this.listenersMap.get(priority);
            if (listeners == null) continue;
            for (PacketListenerCommon listener : listeners) {
                block5: {
                    try {
                        event.call(listener);
                    }
                    catch (Exception t) {
                        if (t.getClass() == InvalidHandshakeException.class) break block5;
                        PacketEvents.getAPI().getLogger().log(Level.WARNING, "PacketEvents caught an unhandled exception while calling your listener.", t);
                    }
                }
                if (postCallListenerAction == null) continue;
                postCallListenerAction.run();
            }
        }
        if (event instanceof ProtocolPacketEvent && !((ProtocolPacketEvent)event).needsReEncode()) {
            ((ProtocolPacketEvent)event).setLastUsedWrapper(null);
        }
    }

    public PacketListenerCommon registerListener(PacketListener listener, PacketListenerPriority priority) {
        PacketListenerAbstract packetListenerAbstract = listener.asAbstract(priority);
        return this.registerListener(packetListenerAbstract);
    }

    public PacketListenerCommon registerListener(PacketListenerCommon listener) {
        byte priority = listener.getPriority().getId();
        Set<PacketListenerCommon> listenerSet = this.listenersMap.get(priority);
        if (listenerSet == null) {
            listenerSet = ConcurrentHashMap.newKeySet();
        }
        listenerSet.add(listener);
        this.listenersMap.put(priority, listenerSet);
        return listener;
    }

    public PacketListenerCommon[] registerListeners(PacketListenerCommon ... listeners) {
        for (PacketListenerCommon listener : listeners) {
            this.registerListener(listener);
        }
        return listeners;
    }

    public void unregisterListener(PacketListenerCommon listener) {
        Set<PacketListenerCommon> listenerSet = this.listenersMap.get(listener.getPriority().getId());
        if (listenerSet == null) {
            return;
        }
        listenerSet.remove(listener);
    }

    public void unregisterListeners(PacketListenerCommon ... listeners) {
        for (PacketListenerCommon listener : listeners) {
            this.unregisterListener(listener);
        }
    }

    public void unregisterAllListeners() {
        this.listenersMap.clear();
    }
}

