/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.common.task;

import com.github.juliarn.npclib.api.PlatformTaskManager;
import com.github.juliarn.npclib.common.task.AsyncTaskThreadFactory;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class AsyncPlatformTaskManager
implements PlatformTaskManager {
    private static final long ONE_TICK_MS = 50L;
    private final ExecutorService runOnceExecutorService;
    private final ScheduledExecutorService scheduledExecutorService;

    private AsyncPlatformTaskManager(@NotNull String extensionId) {
        ThreadFactory runOnceThreadFactory = AsyncTaskThreadFactory.create(extensionId + " NPC-Lib Task #%d");
        this.runOnceExecutorService = Executors.newCachedThreadPool(runOnceThreadFactory);
        ThreadFactory scheduledThreadFactory = AsyncTaskThreadFactory.create(extensionId + " NPC-Lib Scheduled Task #%d");
        this.scheduledExecutorService = Executors.newScheduledThreadPool(0, scheduledThreadFactory);
    }

    @NotNull
    public static PlatformTaskManager taskManager(@NotNull String extensionIdentifier) {
        Objects.requireNonNull(extensionIdentifier, "extensionIdentifier");
        return new AsyncPlatformTaskManager(extensionIdentifier);
    }

    @Override
    public void scheduleSync(@NotNull Runnable task) {
        this.runOnceExecutorService.execute(task);
    }

    @Override
    public void scheduleDelayedSync(@NotNull Runnable task, int delayTicks) {
        this.scheduledExecutorService.schedule(task, (long)delayTicks * 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void scheduleAsync(@NotNull Runnable task) {
        this.runOnceExecutorService.execute(task);
    }

    @Override
    public void scheduleDelayedAsync(@NotNull Runnable task, int delayTicks) {
        this.scheduledExecutorService.schedule(task, (long)delayTicks * 50L, TimeUnit.MILLISECONDS);
    }
}

