/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.common.platform;

import com.github.juliarn.npclib.api.NpcActionController;
import com.github.juliarn.npclib.api.NpcTracker;
import com.github.juliarn.npclib.api.Platform;
import com.github.juliarn.npclib.api.PlatformTaskManager;
import com.github.juliarn.npclib.api.PlatformVersionAccessor;
import com.github.juliarn.npclib.api.PlatformWorldAccessor;
import com.github.juliarn.npclib.api.event.manager.NpcEventManager;
import com.github.juliarn.npclib.api.log.PlatformLogger;
import com.github.juliarn.npclib.api.profile.ProfileResolver;
import com.github.juliarn.npclib.api.protocol.PlatformPacketAdapter;
import com.github.juliarn.npclib.common.CommonNpcTracker;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class CommonPlatformBuilder<W, P, I, E>
implements Platform.Builder<W, P, I, E> {
    protected static final boolean DEFAULT_DEBUG = Boolean.getBoolean("npc.lib.debug");
    protected static final ProfileResolver DEFAULT_PROFILE_RESOLVER = ProfileResolver.caching(ProfileResolver.mojang());
    protected boolean extensionRequired = true;
    protected E extension;
    protected PlatformLogger logger;
    protected boolean debug = DEFAULT_DEBUG;
    protected NpcEventManager eventManager;
    protected NpcTracker<W, P, I, E> npcTracker;
    protected ProfileResolver profileResolver;
    protected PlatformTaskManager taskManager;
    protected PlatformVersionAccessor versionAccessor;
    protected PlatformWorldAccessor<W> worldAccessor;
    protected PlatformPacketAdapter<W, P, I, E> packetAdapter;
    protected Consumer<NpcActionController.Builder> actionControllerDecorator;

    @Override
    @NotNull
    public Platform.Builder<W, P, I, E> debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    @Override
    @NotNull
    public Platform.Builder<W, P, I, E> extension(@NotNull E extension) {
        this.extension = Objects.requireNonNull(extension, "extension");
        return this;
    }

    @Override
    @NotNull
    public CommonPlatformBuilder<W, P, I, E> logger(@NotNull PlatformLogger logger) {
        this.logger = logger;
        return this;
    }

    @Override
    @NotNull
    public Platform.Builder<W, P, I, E> eventManager(@NotNull NpcEventManager eventManager) {
        this.eventManager = Objects.requireNonNull(eventManager, "eventManager");
        return this;
    }

    @Override
    @NotNull
    public Platform.Builder<W, P, I, E> npcTracker(@NotNull NpcTracker<W, P, I, E> npcTracker) {
        this.npcTracker = Objects.requireNonNull(npcTracker, "npcTracker");
        return this;
    }

    @Override
    @NotNull
    public Platform.Builder<W, P, I, E> taskManager(@NotNull PlatformTaskManager taskManager) {
        this.taskManager = Objects.requireNonNull(taskManager, "taskManager");
        return this;
    }

    @Override
    @NotNull
    public Platform.Builder<W, P, I, E> profileResolver(@NotNull ProfileResolver profileResolver) {
        this.profileResolver = Objects.requireNonNull(profileResolver, "profileResolver");
        return this;
    }

    @Override
    @NotNull
    public Platform.Builder<W, P, I, E> worldAccessor(@NotNull PlatformWorldAccessor<W> worldAccessor) {
        this.worldAccessor = Objects.requireNonNull(worldAccessor, "worldAccessor");
        return this;
    }

    @Override
    @NotNull
    public Platform.Builder<W, P, I, E> versionAccessor(@NotNull PlatformVersionAccessor versionAccessor) {
        this.versionAccessor = Objects.requireNonNull(versionAccessor, "versionAccessor");
        return this;
    }

    @Override
    @NotNull
    public Platform.Builder<W, P, I, E> packetFactory(@NotNull PlatformPacketAdapter<W, P, I, E> packetFactory) {
        this.packetAdapter = Objects.requireNonNull(packetFactory, "packetFactory");
        return this;
    }

    @Override
    @NotNull
    public CommonPlatformBuilder<W, P, I, E> actionController(@NotNull Consumer<NpcActionController.Builder> decorator) {
        this.actionControllerDecorator = Objects.requireNonNull(decorator, "decorator");
        return this;
    }

    @Override
    @NotNull
    public Platform<W, P, I, E> build() {
        if (this.extensionRequired) {
            Objects.requireNonNull(this.extension, "extension");
        }
        this.prepareBuild();
        if (this.profileResolver == null) {
            this.profileResolver = DEFAULT_PROFILE_RESOLVER;
        }
        if (this.eventManager == null) {
            this.eventManager = NpcEventManager.createDefault(this.debug, this.logger);
        }
        if (this.npcTracker == null) {
            this.npcTracker = CommonNpcTracker.newNpcTracker();
        }
        return this.doBuild();
    }

    protected abstract void prepareBuild();

    @NotNull
    protected abstract Platform<W, P, I, E> doBuild();
}

