/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.bukkit.util;

import com.github.juliarn.npclib.api.Npc;
import com.github.juliarn.npclib.api.Position;
import com.github.juliarn.npclib.common.util.ClassHelper;
import org.bukkit.Location;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.NotNull;

public final class BukkitPlatformUtil {
    private static final boolean FOLIA = ClassHelper.classExists("io.papermc.paper.threadedregions.RegionizedServerInitEvent");

    private BukkitPlatformUtil() {
        throw new UnsupportedOperationException();
    }

    public static boolean runsOnFolia() {
        return FOLIA;
    }

    public static double distance(@NotNull Npc<?, ?, ?, ?> npc, @NotNull Location location) {
        Position pos = npc.position();
        return NumberConversions.square((double)(location.getX() - pos.x())) + NumberConversions.square((double)(location.getY() - pos.y())) + NumberConversions.square((double)(location.getZ() - pos.z()));
    }

    @NotNull
    public static Position positionFromBukkitLegacy(@NotNull Location loc) {
        return Position.position(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch(), loc.getWorld().getName());
    }

    @NotNull
    public static Position positionFromBukkitModern(@NotNull Location loc) {
        return Position.position(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch(), loc.getWorld().getKey().toString());
    }
}

