/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.bukkit.protocol;

import com.github.juliarn.npclib.api.Npc;
import com.github.juliarn.npclib.api.Platform;
import com.github.juliarn.npclib.api.PlatformVersionAccessor;
import com.github.juliarn.npclib.api.Position;
import com.github.juliarn.npclib.api.event.InteractNpcEvent;
import com.github.juliarn.npclib.api.profile.ProfileProperty;
import com.github.juliarn.npclib.api.protocol.OutboundPacket;
import com.github.juliarn.npclib.api.protocol.PlatformPacketAdapter;
import com.github.juliarn.npclib.api.protocol.enums.EntityAnimation;
import com.github.juliarn.npclib.api.protocol.enums.EntityPose;
import com.github.juliarn.npclib.api.protocol.enums.ItemSlot;
import com.github.juliarn.npclib.api.protocol.enums.PlayerInfoAction;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadata;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadataFactory;
import com.github.juliarn.npclib.common.event.DefaultAttackNpcEvent;
import com.github.juliarn.npclib.common.event.DefaultInteractNpcEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEvents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEventsAPI;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketListenerPriority;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.SimplePacketListenerAbstract;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.simple.PacketPlayReceiveEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.player.PlayerManager;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.data.EntityData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.data.EntityDataType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.type.EntityTypes;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.ItemStack;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.Equipment;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.EquipmentSlot;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.GameMode;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.InteractionHand;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.TextureProperty;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.UserProfile;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.Location;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.settings.PacketEventsSettings;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.TimeStampMode;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.adventure.AdventureSerializer;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.client.WrapperPlayClientInteractEntity;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerEntityAnimation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerEntityEquipment;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerEntityHeadLook;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerEntityRotation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfo;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoRemove;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoUpdate;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerPluginMessage;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerSpawnPlayer;
import com.github.juliarn.npclib.relocate.geantyref.TypeFactory;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util.SpigotReflectionUtil;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import net.kyori.adventure.text.Component;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

final class PacketEventsPacketAdapter
implements PlatformPacketAdapter<World, Player, org.bukkit.inventory.ItemStack, Plugin> {
    static final PacketEventsPacketAdapter INSTANCE = new PacketEventsPacketAdapter();
    private static final PacketEventsSettings PACKET_EVENTS_SETTINGS = new PacketEventsSettings().debug(false).bStats(true).checkForUpdates(false).reEncodeByDefault(false).timeStampMode(TimeStampMode.NONE);
    private static final Type OPTIONAL_CHAT_COMPONENT_TYPE = TypeFactory.parameterizedClass(Optional.class, new Type[]{Component.class});
    private ServerVersion serverVersion;
    private PlayerManager packetPlayerManager;

    PacketEventsPacketAdapter() {
    }

    @NotNull
    private static Location npcLocation(@NotNull Npc<?, ?, ?, ?> npc) {
        return PacketEventsPacketAdapter.npcLocation(npc, npc.position().yaw(), npc.position().pitch());
    }

    @NotNull
    private static Location npcLocation(@NotNull Npc<?, ?, ?, ?> npc, float yaw, float pitch) {
        Position pos = npc.position();
        return new Location(pos.x(), pos.y(), pos.z(), yaw, pitch);
    }

    @NotNull
    private static EntityData createEntityData(int index, @NotNull Type type, @NotNull Object value, @NotNull PlatformVersionAccessor versionAccessor) {
        BiFunction converter = (BiFunction)Lazy.SERIALIZER_CONVERTERS.get(type);
        if (converter != null) {
            Map.Entry converted = (Map.Entry)converter.apply(versionAccessor, value);
            type = (Type)converted.getKey();
            value = converted.getValue();
        }
        return new EntityData(index, (EntityDataType)Lazy.ENTITY_DATA_TYPE_LOOKUP.get(type), value);
    }

    @Override
    @NotNull
    public OutboundPacket<World, Player, org.bukkit.inventory.ItemStack, Plugin> createEntitySpawnPacket() {
        return (player, npc) -> {
            Location location = PacketEventsPacketAdapter.npcLocation(npc);
            PacketWrapper wrapper = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_2) ? new WrapperPlayServerSpawnEntity(npc.entityId(), Optional.of(npc.profile().uniqueId()), EntityTypes.PLAYER, location.getPosition(), location.getPitch(), location.getYaw(), 0.0f, 0, Optional.empty()) : new WrapperPlayServerSpawnPlayer(npc.entityId(), npc.profile().uniqueId(), location, new EntityData[0]);
            this.packetPlayerManager.sendPacketSilently(player, wrapper);
        };
    }

    @Override
    @NotNull
    public OutboundPacket<World, Player, org.bukkit.inventory.ItemStack, Plugin> createEntityRemovePacket() {
        return (player, npc) -> {
            WrapperPlayServerDestroyEntities wrapper = new WrapperPlayServerDestroyEntities(npc.entityId());
            this.packetPlayerManager.sendPacketSilently(player, wrapper);
        };
    }

    @Override
    @NotNull
    public OutboundPacket<World, Player, org.bukkit.inventory.ItemStack, Plugin> createPlayerInfoPacket(@NotNull PlayerInfoAction action) {
        return (player, npc) -> npc.settings().profileResolver().resolveNpcProfile((Player)player, npc).thenAcceptAsync(profile -> {
            PacketWrapper wrapper;
            UserProfile userProfile = new UserProfile(profile.uniqueId(), profile.name());
            for (ProfileProperty property : profile.properties()) {
                TextureProperty textureProperty = new TextureProperty(property.name(), property.value(), property.signature());
                userProfile.getTextureProperties().add(textureProperty);
            }
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
                if (action == PlayerInfoAction.REMOVE_PLAYER) {
                    List<UUID> uuidsToRemove = Collections.singletonList(profile.uniqueId());
                    wrapper = new WrapperPlayServerPlayerInfoRemove(uuidsToRemove);
                } else {
                    WrapperPlayServerPlayerInfoUpdate.PlayerInfo playerInfo = new WrapperPlayServerPlayerInfoUpdate.PlayerInfo(userProfile, false, 20, GameMode.CREATIVE, null, null);
                    wrapper = new WrapperPlayServerPlayerInfoUpdate((EnumSet<WrapperPlayServerPlayerInfoUpdate.Action>)Lazy.ADD_ACTIONS, Collections.singletonList(playerInfo));
                }
            } else {
                WrapperPlayServerPlayerInfo.PlayerData playerData = new WrapperPlayServerPlayerInfo.PlayerData(null, userProfile, GameMode.CREATIVE, 20);
                WrapperPlayServerPlayerInfo.Action playerInfoAction = (WrapperPlayServerPlayerInfo.Action)((Object)((Object)((Object)Lazy.PLAYER_INFO_ACTION_CONVERTER.get((Object)action))));
                wrapper = new WrapperPlayServerPlayerInfo(playerInfoAction, playerData);
            }
            this.packetPlayerManager.sendPacketSilently(player, wrapper);
        });
    }

    @Override
    @NotNull
    public OutboundPacket<World, Player, org.bukkit.inventory.ItemStack, Plugin> createRotationPacket(float yaw, float pitch) {
        return (player, npc) -> {
            WrapperPlayServerEntityHeadLook headRotation = new WrapperPlayServerEntityHeadLook(npc.entityId(), yaw);
            PacketWrapper rotation = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9) ? new WrapperPlayServerEntityRotation(npc.entityId(), yaw, pitch, true) : new WrapperPlayServerEntityTeleport(npc.entityId(), PacketEventsPacketAdapter.npcLocation(npc, yaw, pitch), true);
            this.packetPlayerManager.sendPacketSilently(player, rotation);
            this.packetPlayerManager.sendPacketSilently(player, headRotation);
        };
    }

    @Override
    @NotNull
    public OutboundPacket<World, Player, org.bukkit.inventory.ItemStack, Plugin> createAnimationPacket(@NotNull EntityAnimation animation) {
        return (player, npc) -> {
            WrapperPlayServerEntityAnimation.EntityAnimationType animationType = (WrapperPlayServerEntityAnimation.EntityAnimationType)((Object)((Object)Lazy.ENTITY_ANIMATION_CONVERTER.get((Object)animation)));
            WrapperPlayServerEntityAnimation wrapper = new WrapperPlayServerEntityAnimation(npc.entityId(), animationType);
            this.packetPlayerManager.sendPacketSilently(player, wrapper);
        };
    }

    @Override
    @NotNull
    public OutboundPacket<World, Player, org.bukkit.inventory.ItemStack, Plugin> createEquipmentPacket(@NotNull ItemSlot slot, @NotNull org.bukkit.inventory.ItemStack item) {
        return (player, npc) -> {
            EquipmentSlot equipmentSlot = (EquipmentSlot)((Object)((Object)Lazy.ITEM_SLOT_CONVERTER.get((Object)slot)));
            ItemStack is = SpigotReflectionUtil.decodeBukkitItemStack(item);
            Equipment equipment = new Equipment(equipmentSlot, is);
            WrapperPlayServerEntityEquipment wrapper = new WrapperPlayServerEntityEquipment(npc.entityId(), Collections.singletonList(equipment));
            this.packetPlayerManager.sendPacketSilently(player, wrapper);
        };
    }

    @Override
    @NotNull
    public OutboundPacket<World, Player, org.bukkit.inventory.ItemStack, Plugin> createCustomPayloadPacket(@NotNull String channelId, byte[] payload) {
        return (player, npc) -> {
            WrapperPlayServerPluginMessage wrapper = new WrapperPlayServerPluginMessage(channelId, payload);
            this.packetPlayerManager.sendPacketSilently(player, wrapper);
        };
    }

    @Override
    @NotNull
    public <T, O> OutboundPacket<World, Player, org.bukkit.inventory.ItemStack, Plugin> createEntityMetaPacket(@NotNull EntityMetadataFactory<T, O> metadata, @NotNull T value) {
        return (player, npc) -> {
            PlatformVersionAccessor versionAccessor = npc.platform().versionAccessor();
            EntityMetadata entityMetadata = metadata.create(value, versionAccessor);
            if (!entityMetadata.available()) {
                return;
            }
            ArrayList<EntityData> entityData = new ArrayList<EntityData>();
            entityData.add(PacketEventsPacketAdapter.createEntityData(entityMetadata.index(), entityMetadata.type(), entityMetadata.value(), versionAccessor));
            for (EntityMetadataFactory<Object, Object> entityMetadataFactory : metadata.relatedMetadata()) {
                EntityMetadata<Object> related = entityMetadataFactory.create(value, versionAccessor);
                if (!related.available()) continue;
                entityData.add(PacketEventsPacketAdapter.createEntityData(related.index(), related.type(), related.value(), versionAccessor));
            }
            WrapperPlayServerEntityMetadata wrapper = new WrapperPlayServerEntityMetadata(npc.entityId(), entityData);
            this.packetPlayerManager.sendPacketSilently(player, wrapper);
        };
    }

    @Override
    public void initialize(@NotNull Platform<World, Player, org.bukkit.inventory.ItemStack, Plugin> platform) {
        PacketEventsAPI<Plugin> packetEventsApi = SpigotPacketEventsBuilder.buildNoCache(platform.extension(), PACKET_EVENTS_SETTINGS);
        PacketEvents.setAPI(packetEventsApi);
        packetEventsApi.init();
        this.packetPlayerManager = packetEventsApi.getPlayerManager();
        this.serverVersion = packetEventsApi.getServerManager().getVersion();
        packetEventsApi.getEventManager().registerListener(new NpcUsePacketAdapter(platform));
    }

    private static final class Lazy {
        private static final EnumMap<ItemSlot, EquipmentSlot> ITEM_SLOT_CONVERTER;
        private static final EnumMap<InteractionHand, InteractNpcEvent.Hand> HAND_CONVERTER;
        private static final EnumMap<PlayerInfoAction, WrapperPlayServerPlayerInfo.Action> PLAYER_INFO_ACTION_CONVERTER;
        private static final EnumMap<EntityAnimation, WrapperPlayServerEntityAnimation.EntityAnimationType> ENTITY_ANIMATION_CONVERTER;
        private static final EnumMap<EntityPose, com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose> ENTITY_POSE_CONVERTER;
        private static final Map<Type, EntityDataType<?>> ENTITY_DATA_TYPE_LOOKUP;
        private static final Map<Type, BiFunction<PlatformVersionAccessor, Object, Map.Entry<Type, Object>>> SERIALIZER_CONVERTERS;
        private static final EnumSet<WrapperPlayServerPlayerInfoUpdate.Action> ADD_ACTIONS;

        private Lazy() {
        }

        static {
            ADD_ACTIONS = EnumSet.of(WrapperPlayServerPlayerInfoUpdate.Action.ADD_PLAYER, WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_LISTED, WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_LATENCY, WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_GAME_MODE, WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_DISPLAY_NAME);
            ITEM_SLOT_CONVERTER = new EnumMap(ItemSlot.class);
            ITEM_SLOT_CONVERTER.put(ItemSlot.MAIN_HAND, EquipmentSlot.MAIN_HAND);
            ITEM_SLOT_CONVERTER.put(ItemSlot.OFF_HAND, EquipmentSlot.OFF_HAND);
            ITEM_SLOT_CONVERTER.put(ItemSlot.FEET, EquipmentSlot.BOOTS);
            ITEM_SLOT_CONVERTER.put(ItemSlot.LEGS, EquipmentSlot.LEGGINGS);
            ITEM_SLOT_CONVERTER.put(ItemSlot.CHEST, EquipmentSlot.CHEST_PLATE);
            ITEM_SLOT_CONVERTER.put(ItemSlot.HEAD, EquipmentSlot.HELMET);
            HAND_CONVERTER = new EnumMap(InteractionHand.class);
            HAND_CONVERTER.put(InteractionHand.MAIN_HAND, InteractNpcEvent.Hand.MAIN_HAND);
            HAND_CONVERTER.put(InteractionHand.OFF_HAND, InteractNpcEvent.Hand.OFF_HAND);
            PLAYER_INFO_ACTION_CONVERTER = new EnumMap(PlayerInfoAction.class);
            PLAYER_INFO_ACTION_CONVERTER.put(PlayerInfoAction.ADD_PLAYER, WrapperPlayServerPlayerInfo.Action.ADD_PLAYER);
            PLAYER_INFO_ACTION_CONVERTER.put(PlayerInfoAction.REMOVE_PLAYER, WrapperPlayServerPlayerInfo.Action.REMOVE_PLAYER);
            ENTITY_ANIMATION_CONVERTER = new EnumMap(EntityAnimation.class);
            ENTITY_ANIMATION_CONVERTER.put(EntityAnimation.SWING_MAIN_ARM, WrapperPlayServerEntityAnimation.EntityAnimationType.SWING_MAIN_ARM);
            ENTITY_ANIMATION_CONVERTER.put(EntityAnimation.TAKE_DAMAGE, WrapperPlayServerEntityAnimation.EntityAnimationType.HURT);
            ENTITY_ANIMATION_CONVERTER.put(EntityAnimation.LEAVE_BED, WrapperPlayServerEntityAnimation.EntityAnimationType.WAKE_UP);
            ENTITY_ANIMATION_CONVERTER.put(EntityAnimation.SWING_OFF_HAND, WrapperPlayServerEntityAnimation.EntityAnimationType.SWING_OFF_HAND);
            ENTITY_ANIMATION_CONVERTER.put(EntityAnimation.CRITICAL_EFFECT, WrapperPlayServerEntityAnimation.EntityAnimationType.CRITICAL_HIT);
            ENTITY_ANIMATION_CONVERTER.put(EntityAnimation.MAGIC_CRITICAL_EFFECT, WrapperPlayServerEntityAnimation.EntityAnimationType.MAGIC_CRITICAL_HIT);
            ENTITY_POSE_CONVERTER = new EnumMap(EntityPose.class);
            ENTITY_POSE_CONVERTER.put(EntityPose.STANDING, com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose.STANDING);
            ENTITY_POSE_CONVERTER.put(EntityPose.FALL_FLYING, com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose.FALL_FLYING);
            ENTITY_POSE_CONVERTER.put(EntityPose.SLEEPING, com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose.SLEEPING);
            ENTITY_POSE_CONVERTER.put(EntityPose.SWIMMING, com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose.SWIMMING);
            ENTITY_POSE_CONVERTER.put(EntityPose.SPIN_ATTACK, com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose.SPIN_ATTACK);
            ENTITY_POSE_CONVERTER.put(EntityPose.CROUCHING, com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose.CROUCHING);
            ENTITY_POSE_CONVERTER.put(EntityPose.LONG_JUMPING, com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose.LONG_JUMPING);
            ENTITY_POSE_CONVERTER.put(EntityPose.DYING, com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose.DYING);
            ENTITY_POSE_CONVERTER.put(EntityPose.CROAKING, com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose.CROAKING);
            ENTITY_POSE_CONVERTER.put(EntityPose.USING_TONGUE, com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose.USING_TONGUE);
            ENTITY_POSE_CONVERTER.put(EntityPose.ROARING, com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose.ROARING);
            ENTITY_POSE_CONVERTER.put(EntityPose.SNIFFING, com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose.SNIFFING);
            ENTITY_POSE_CONVERTER.put(EntityPose.EMERGING, com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose.EMERGING);
            ENTITY_POSE_CONVERTER.put(EntityPose.DIGGING, com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose.DIGGING);
            SERIALIZER_CONVERTERS = ImmutableMap.builder().put(EntityPose.class, ($, value) -> new AbstractMap.SimpleImmutableEntry<Class<com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose>, com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose>(com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose.class, ENTITY_POSE_CONVERTER.get(value))).put((Object)TypeFactory.parameterizedClass(Optional.class, new Type[]{com.github.juliarn.npclib.api.protocol.chat.Component.class}), (versionAccessor, value) -> {
                Optional optionalComponent = (Optional)value;
                if (versionAccessor.atLeast(1, 13, 0)) {
                    return new AbstractMap.SimpleImmutableEntry<Type, Optional<Component>>(OPTIONAL_CHAT_COMPONENT_TYPE, optionalComponent.map(component -> {
                        if (component.rawMessage() != null) {
                            return AdventureSerializer.fromLegacyFormat(component.rawMessage());
                        }
                        return AdventureSerializer.getGsonSerializer().deserializeOrNull(component.encodedJsonMessage());
                    }));
                }
                return new AbstractMap.SimpleImmutableEntry<Class<String>, Object>(String.class, optionalComponent.map(component -> Objects.requireNonNull(component.rawMessage(), "Versions older than 1.13 don't support json component")).orElse(null));
            }).build();
            ENTITY_DATA_TYPE_LOOKUP = ImmutableMap.builder().put(Byte.class, EntityDataTypes.BYTE).put(Integer.class, EntityDataTypes.INT).put(Float.class, EntityDataTypes.FLOAT).put(Boolean.class, EntityDataTypes.BOOLEAN).put(String.class, EntityDataTypes.STRING).put((Object)OPTIONAL_CHAT_COMPONENT_TYPE, EntityDataTypes.OPTIONAL_COMPONENT).put(com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.entity.pose.EntityPose.class, EntityDataTypes.ENTITY_POSE).build();
        }
    }

    private static final class NpcUsePacketAdapter
    extends SimplePacketListenerAbstract {
        private final Platform<World, Player, org.bukkit.inventory.ItemStack, Plugin> platform;

        public NpcUsePacketAdapter(@NotNull Platform<World, Player, org.bukkit.inventory.ItemStack, Plugin> platform) {
            super(PacketListenerPriority.MONITOR);
            this.platform = platform;
        }

        @Override
        public void onPacketPlayReceive(@NotNull PacketPlayReceiveEvent event) {
            Object player = event.getPlayer();
            if (event.getPacketType() == PacketType.Play.Client.INTERACT_ENTITY) {
                WrapperPlayClientInteractEntity packet = new WrapperPlayClientInteractEntity(event);
                Npc<World, Player, org.bukkit.inventory.ItemStack, Plugin> npc = this.platform.npcTracker().npcById(packet.getEntityId());
                if (npc != null) {
                    switch (packet.getAction()) {
                        case ATTACK: {
                            this.platform.eventManager().post(DefaultAttackNpcEvent.attackNpc(npc, player));
                            break;
                        }
                        case INTERACT: {
                            InteractNpcEvent.Hand hand = (InteractNpcEvent.Hand)((Object)Lazy.HAND_CONVERTER.get((Object)packet.getHand()));
                            this.platform.eventManager().post(DefaultInteractNpcEvent.interactNpc(npc, player, hand));
                            break;
                        }
                    }
                    event.setCancelled(true);
                }
            }
        }
    }
}

